/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.EgressPublisher;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.security.SessionProxy;

final class ClusterSessionProxy
implements SessionProxy {
    private final EgressPublisher egressPublisher;
    private ClusterSession clusterSession;

    ClusterSessionProxy(EgressPublisher egressPublisher) {
        this.egressPublisher = egressPublisher;
    }

    SessionProxy session(ClusterSession clusterSession) {
        this.clusterSession = clusterSession;
        return this;
    }

    public long sessionId() {
        return this.clusterSession.id();
    }

    public boolean challenge(byte[] encodedChallenge) {
        if (this.egressPublisher.sendChallenge(this.clusterSession, encodedChallenge)) {
            this.clusterSession.state(ClusterSession.State.CHALLENGED, "challenged");
            return true;
        }
        return false;
    }

    public boolean authenticate(byte[] encodedPrincipal) {
        ClusterSession.checkEncodedPrincipalLength(encodedPrincipal);
        this.clusterSession.authenticate(encodedPrincipal);
        return true;
    }

    public void reject() {
        this.clusterSession.reject(EventCode.AUTHENTICATION_REJECTED, "session failed authentication", null);
    }
}

