/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.RethrowingErrorHandler;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.AppVersionValidator;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.cluster.service.ClusterCounters;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.cluster.service.SnapshotDurationTracker;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.agrona.CloseHelper;
import org.agrona.DelegatingErrorHandler;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.MarkFile;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.StatusIndicator;

public final class ClusteredServiceContainer
implements AutoCloseable {
    private final Context ctx;
    private final AgentRunner serviceAgentRunner;

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        try (ShutdownSignalBarrier barrier = new ShutdownSignalBarrier();
             ClusteredServiceContainer ignore = ClusteredServiceContainer.launch(new Context().terminationHook(() -> ((ShutdownSignalBarrier)barrier).signalAll()));){
            barrier.await();
            System.out.println("Shutdown ClusteredServiceContainer...");
        }
    }

    private ClusteredServiceContainer(Context ctx) {
        this.ctx = ctx;
        try {
            ctx.conclude();
        }
        catch (Exception ex) {
            ClusterMarkFile markFile = ctx.markFile;
            if (null != markFile) {
                markFile.signalFailedStart();
            }
            ctx.close();
            throw ex;
        }
        ClusteredServiceAgent agent = new ClusteredServiceAgent(ctx);
        this.serviceAgentRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), (Agent)agent);
    }

    public static ClusteredServiceContainer launch() {
        return ClusteredServiceContainer.launch(new Context());
    }

    public static ClusteredServiceContainer launch(Context ctx) {
        ClusteredServiceContainer clusteredServiceContainer = new ClusteredServiceContainer(ctx);
        AgentRunner.startOnThread((AgentRunner)clusteredServiceContainer.serviceAgentRunner, (ThreadFactory)ctx.threadFactory());
        return clusteredServiceContainer;
    }

    public Context context() {
        return this.ctx;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.serviceAgentRunner);
    }

    public static final class Context
    implements Cloneable {
        private static final VarHandle IS_CONCLUDED_VH;
        private volatile boolean isConcluded;
        private int appVersion = SemanticVersion.compose((int)0, (int)0, (int)1);
        private int clusterId = Configuration.clusterId();
        private int serviceId = Configuration.serviceId();
        private String serviceName = System.getProperty("aeron.cluster.service.name");
        private String replayChannel = Configuration.replayChannel();
        private int replayStreamId = Configuration.replayStreamId();
        private String controlChannel = Configuration.controlChannel();
        private int consensusModuleStreamId = Configuration.consensusModuleStreamId();
        private int serviceStreamId = Configuration.serviceStreamId();
        private String snapshotChannel = Configuration.snapshotChannel();
        private int snapshotStreamId = Configuration.snapshotStreamId();
        private int errorBufferLength = Configuration.errorBufferLength();
        private boolean isRespondingService = Configuration.isRespondingService();
        private int logFragmentLimit = Configuration.logFragmentLimit();
        private long cycleThresholdNs = Configuration.cycleThresholdNs();
        private long snapshotDurationThresholdNs = Configuration.snapshotDurationThresholdNs();
        private boolean standbySnapshotEnabled = Configuration.standbySnapshotEnabled();
        private CountDownLatch abortLatch;
        private ThreadFactory threadFactory;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private DelegatingErrorHandler delegatingErrorHandler;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private AeronArchive.Context archiveContext;
        private String clusterDirectoryName = Configuration.clusterDirName();
        private File clusterDir;
        private File markFileDir;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private DutyCycleTracker dutyCycleTracker;
        private SnapshotDurationTracker snapshotDurationTracker;
        private AppVersionValidator appVersionValidator;
        private boolean ownsAeronClient;
        private ClusteredService clusteredService;
        private Runnable terminationHook;
        private ClusterMarkFile markFile;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (IS_CONCLUDED_VH.getAndSet(this, true)) {
                throw new ConcurrentConcludeException();
            }
            if (this.serviceId < 0 || this.serviceId > 127) {
                throw new ConfigurationException("service id outside allowed range (0-127): " + this.serviceId);
            }
            if (null == this.threadFactory) {
                this.threadFactory = Thread::new;
            }
            if (null == this.idleStrategySupplier) {
                this.idleStrategySupplier = Configuration.idleStrategySupplier(null);
            }
            if (null == this.appVersionValidator) {
                this.appVersionValidator = AppVersionValidator.SEMANTIC_VERSIONING_VALIDATOR;
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (null == this.clusterDir) {
                this.clusterDir = new File(this.clusterDirectoryName);
            }
            if (null == this.markFileDir) {
                String dir = Configuration.markFileDir();
                this.markFileDir = Strings.isEmpty((String)dir) ? this.clusterDir : new File(dir);
            }
            try {
                this.clusterDir = this.clusterDir.getCanonicalFile();
                this.clusterDirectoryName = this.clusterDir.getAbsolutePath();
                this.markFileDir = this.markFileDir.getCanonicalFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            IoUtil.ensureDirectoryExists((File)this.clusterDir, (String)"cluster");
            IoUtil.ensureDirectoryExists((File)this.markFileDir, (String)"mark file");
            if (null == this.markFile) {
                int filePageSize = null != this.aeron ? this.aeron.context().filePageSize() : CommonContext.driverFilePageSize((File)new File(this.aeronDirectoryName), (EpochClock)this.epochClock, (long)new CommonContext().driverTimeoutMs());
                this.markFile = new ClusterMarkFile(new File(this.markFileDir, ClusterMarkFile.markFilenameForService(this.serviceId)), ClusterComponentType.CONTAINER, this.errorBufferLength, this.epochClock, Configuration.LIVENESS_TIMEOUT_MS, filePageSize);
            }
            MarkFile.ensureMarkFileLink((File)this.clusterDir, (File)new File(this.markFile.parentDirectory(), ClusterMarkFile.markFilenameForService(this.serviceId)), (String)ClusterMarkFile.linkFilenameForService(this.serviceId));
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog(this.markFile.errorBuffer(), this.epochClock, StandardCharsets.US_ASCII);
            }
            this.errorHandler = CommonContext.setupErrorHandler((ErrorHandler)this.errorHandler, (DistinctErrorLog)this.errorLog);
            if (null == this.delegatingErrorHandler) {
                this.delegatingErrorHandler = Configuration.newDelegatingErrorHandler();
                if (null != this.delegatingErrorHandler) {
                    this.delegatingErrorHandler.next(this.errorHandler);
                    this.errorHandler = this.delegatingErrorHandler;
                }
            } else {
                this.delegatingErrorHandler.next(this.errorHandler);
                this.errorHandler = this.delegatingErrorHandler;
            }
            if (Strings.isEmpty((String)this.serviceName)) {
                this.serviceName = "clustered-service-" + this.clusterId + "-" + this.serviceId;
            }
            if (null == this.aeron) {
                this.aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler).subscriberErrorHandler((ErrorHandler)RethrowingErrorHandler.INSTANCE).awaitingIdleStrategy((IdleStrategy)YieldingIdleStrategy.INSTANCE).epochClock(this.epochClock).clientName(this.serviceName));
                this.ownsAeronClient = true;
            }
            if (!(this.aeron.context().subscriberErrorHandler() instanceof RethrowingErrorHandler)) {
                throw new ClusterException("Aeron client must use a RethrowingErrorHandler");
            }
            ExpandableArrayBuffer tempBuffer = new ExpandableArrayBuffer();
            if (null == this.errorCounter) {
                this.errorCounter = ClusterCounters.allocateServiceErrorCounter(this.aeron, (MutableDirectBuffer)tempBuffer, this.clusterId, this.serviceId);
            }
            if (null == this.countedErrorHandler) {
                this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
                if (this.ownsAeronClient) {
                    this.aeron.context().errorHandler((ErrorHandler)this.countedErrorHandler);
                }
            }
            if (null == this.dutyCycleTracker) {
                this.dutyCycleTracker = new DutyCycleStallTracker((AtomicCounter)ClusterCounters.allocateServiceCounter(this.aeron, (MutableDirectBuffer)tempBuffer, "Cluster container max cycle time in ns", 218, this.clusterId, this.serviceId), (AtomicCounter)ClusterCounters.allocateServiceCounter(this.aeron, (MutableDirectBuffer)tempBuffer, "Cluster container work cycle time exceeded count: threshold=" + this.cycleThresholdNs + "ns", 219, this.clusterId, this.serviceId), this.cycleThresholdNs);
            }
            if (null == this.snapshotDurationTracker) {
                this.snapshotDurationTracker = new SnapshotDurationTracker((AtomicCounter)ClusterCounters.allocateServiceCounter(this.aeron, (MutableDirectBuffer)tempBuffer, "Clustered service max snapshot duration in ns", 236, this.clusterId, this.serviceId), (AtomicCounter)ClusterCounters.allocateServiceCounter(this.aeron, (MutableDirectBuffer)tempBuffer, "Clustered service max snapshot duration exceeded count: threshold=" + this.snapshotDurationThresholdNs, 237, this.clusterId, this.serviceId), this.snapshotDurationThresholdNs);
            }
            if (null == this.archiveContext) {
                this.archiveContext = new AeronArchive.Context().controlRequestChannel(AeronArchive.Configuration.localControlChannel()).controlResponseChannel(AeronArchive.Configuration.localControlChannel()).controlRequestStreamId(AeronArchive.Configuration.localControlStreamId()).controlResponseStreamId(this.clusterId * 100 + 100 + AeronArchive.Configuration.controlResponseStreamId() + (this.serviceId + 1));
            }
            if (!this.archiveContext.controlRequestChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            if (!this.archiveContext.controlResponseChannel().startsWith("aeron:ipc")) {
                throw new ClusterException("local archive control must be IPC");
            }
            this.archiveContext.aeron(this.aeron).ownsAeronClient(false).lock((Lock)NoOpLock.INSTANCE).errorHandler((ErrorHandler)this.countedErrorHandler).controlRequestChannel(ChannelUri.addAliasIfAbsent((String)this.archiveContext.controlRequestChannel(), (String)("sc-" + this.serviceId + "-archive-ctrl-req-cluster-" + this.clusterId))).controlResponseChannel(ChannelUri.addAliasIfAbsent((String)this.archiveContext.controlResponseChannel(), (String)("sc-" + this.serviceId + "-archive-ctrl-resp-cluster-" + this.clusterId))).clientName(this.serviceName);
            if (null == this.terminationHook) {
                this.terminationHook = () -> {};
            }
            if (null == this.clusteredService) {
                this.clusteredService = Configuration.newClusteredService();
            }
            this.abortLatch = new CountDownLatch(!this.aeron.context().useConductorAgentInvoker() ? 1 : 0);
            this.concludeMarkFile();
            if (CommonContext.shouldPrintConfigurationOnStart()) {
                System.out.println(this);
            }
        }

        public boolean isConcluded() {
            return this.isConcluded;
        }

        public Context appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public int appVersion() {
            return this.appVersion;
        }

        public Context appVersionValidator(AppVersionValidator appVersionValidator) {
            this.appVersionValidator = appVersionValidator;
            return this;
        }

        public AppVersionValidator appVersionValidator() {
            return this.appVersionValidator;
        }

        public Context clusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public int clusterId() {
            return this.clusterId;
        }

        public Context serviceId(int serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public int serviceId() {
            return this.serviceId;
        }

        public Context serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public String serviceName() {
            return this.serviceName;
        }

        public Context replayChannel(String channel) {
            this.replayChannel = channel;
            return this;
        }

        public String replayChannel() {
            return this.replayChannel;
        }

        public Context replayStreamId(int streamId) {
            this.replayStreamId = streamId;
            return this;
        }

        public int replayStreamId() {
            return this.replayStreamId;
        }

        public Context controlChannel(String channel) {
            this.controlChannel = channel;
            return this;
        }

        public String controlChannel() {
            return this.controlChannel;
        }

        public Context serviceStreamId(int streamId) {
            this.serviceStreamId = streamId;
            return this;
        }

        public int serviceStreamId() {
            return this.serviceStreamId;
        }

        public Context consensusModuleStreamId(int streamId) {
            this.consensusModuleStreamId = streamId;
            return this;
        }

        public int consensusModuleStreamId() {
            return this.consensusModuleStreamId;
        }

        public Context snapshotChannel(String channel) {
            this.snapshotChannel = channel;
            return this;
        }

        public String snapshotChannel() {
            return this.snapshotChannel;
        }

        public Context snapshotStreamId(int streamId) {
            this.snapshotStreamId = streamId;
            return this;
        }

        public int snapshotStreamId() {
            return this.snapshotStreamId;
        }

        public Context isRespondingService(boolean isRespondingService) {
            this.isRespondingService = isRespondingService;
            return this;
        }

        public Context logFragmentLimit(int logFragmentLimit) {
            this.logFragmentLimit = logFragmentLimit;
            return this;
        }

        public int logFragmentLimit() {
            return this.logFragmentLimit;
        }

        public boolean isRespondingService() {
            return this.isRespondingService;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public DelegatingErrorHandler delegatingErrorHandler() {
            return this.delegatingErrorHandler;
        }

        public Context delegatingErrorHandler(DelegatingErrorHandler delegatingErrorHandler) {
            this.delegatingErrorHandler = delegatingErrorHandler;
            return this;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public Context errorCounter(AtomicCounter errorCounter) {
            this.errorCounter = errorCounter;
            return this;
        }

        public Context countedErrorHandler(CountedErrorHandler countedErrorHandler) {
            this.countedErrorHandler = countedErrorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public ClusteredService clusteredService() {
            return this.clusteredService;
        }

        public Context clusteredService(ClusteredService clusteredService) {
            this.clusteredService = clusteredService;
            return this;
        }

        public Context archiveContext(AeronArchive.Context archiveContext) {
            this.archiveContext = archiveContext;
            return this;
        }

        public AeronArchive.Context archiveContext() {
            return this.archiveContext;
        }

        public Context clusterDirectoryName(String clusterDirectoryName) {
            this.clusterDirectoryName = clusterDirectoryName;
            return this;
        }

        public String clusterDirectoryName() {
            return this.clusterDirectoryName;
        }

        public Context clusterDir(File clusterDir) {
            this.clusterDir = clusterDir;
            return this;
        }

        public File clusterDir() {
            return this.clusterDir;
        }

        public File markFileDir() {
            return this.markFileDir;
        }

        public Context markFileDir(File markFileDir) {
            this.markFileDir = markFileDir;
            return this;
        }

        public Context terminationHook(Runnable terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        public Runnable terminationHook() {
            return this.terminationHook;
        }

        public Context clusterMarkFile(ClusterMarkFile markFile) {
            this.markFile = markFile;
            return this;
        }

        public ClusterMarkFile clusterMarkFile() {
            return this.markFile;
        }

        public Context errorBufferLength(int errorBufferLength) {
            this.errorBufferLength = errorBufferLength;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public Context cycleThresholdNs(long thresholdNs) {
            this.cycleThresholdNs = thresholdNs;
            return this;
        }

        public long cycleThresholdNs() {
            return this.cycleThresholdNs;
        }

        public Context dutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.dutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker dutyCycleTracker() {
            return this.dutyCycleTracker;
        }

        public Context snapshotDurationThresholdNs(long thresholdNs) {
            this.snapshotDurationThresholdNs = thresholdNs;
            return this;
        }

        public long snapshotDurationThresholdNs() {
            return this.snapshotDurationThresholdNs;
        }

        public Context snapshotDurationTracker(SnapshotDurationTracker snapshotDurationTracker) {
            this.snapshotDurationTracker = snapshotDurationTracker;
            return this;
        }

        public SnapshotDurationTracker snapshotDurationTracker() {
            return this.snapshotDurationTracker;
        }

        public void deleteDirectory() {
            if (null != this.clusterDir) {
                IoUtil.delete((File)this.clusterDir, (boolean)false);
            }
        }

        public boolean standbySnapshotEnabled() {
            return this.standbySnapshotEnabled;
        }

        public Context standbySnapshotEnabled(boolean standbySnapshotEnabled) {
            this.standbySnapshotEnabled = standbySnapshotEnabled;
            return this;
        }

        public void close() {
            CountedErrorHandler errorHandler = this.countedErrorHandler();
            if (this.ownsAeronClient) {
                CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.aeron);
            }
            CloseHelper.close((AutoCloseable)this.markFile);
        }

        CountDownLatch abortLatch() {
            return this.abortLatch;
        }

        private void concludeMarkFile() {
            ClusterMarkFile.checkHeaderLength(this.aeron.context().aeronDirectoryName(), this.controlChannel(), null, this.serviceName, null);
            MarkFileHeaderEncoder encoder = this.markFile.encoder();
            encoder.archiveStreamId(this.archiveContext.controlRequestStreamId()).serviceStreamId(this.serviceStreamId).consensusModuleStreamId(this.consensusModuleStreamId).ingressStreamId(-1).memberId(-1).serviceId(this.serviceId).clusterId(this.clusterId).aeronDirectory(this.aeron.context().aeronDirectoryName()).controlChannel(this.controlChannel).ingressChannel(null).serviceName(this.serviceName).authenticator(null);
            this.markFile.signalReady(this.epochClock.time());
        }

        public String toString() {
            return "ClusteredServiceContainer.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    ownsAeronClient=" + this.ownsAeronClient + "\n    aeronDirectoryName='" + this.aeronDirectoryName + "'\n    aeron=" + String.valueOf(this.aeron) + "\n    archiveContext=" + String.valueOf(this.archiveContext) + "\n    clusterDirectoryName='" + this.clusterDirectoryName + "'\n    clusterDir=" + String.valueOf(this.clusterDir) + "\n    appVersion=" + this.appVersion + "\n    clusterId=" + this.clusterId + "\n    serviceId=" + this.serviceId + "\n    serviceName='" + this.serviceName + "'\n    replayChannel='" + this.replayChannel + "'\n    replayStreamId=" + this.replayStreamId + "\n    controlChannel='" + this.controlChannel + "'\n    consensusModuleStreamId=" + this.consensusModuleStreamId + "\n    serviceStreamId=" + this.serviceStreamId + "\n    snapshotChannel='" + this.snapshotChannel + "'\n    snapshotStreamId=" + this.snapshotStreamId + "\n    errorBufferLength=" + this.errorBufferLength + "\n    isRespondingService=" + this.isRespondingService + "\n    logFragmentLimit=" + this.logFragmentLimit + "\n    abortLatch=" + String.valueOf(this.abortLatch) + "\n    threadFactory=" + String.valueOf(this.threadFactory) + "\n    idleStrategySupplier=" + String.valueOf(this.idleStrategySupplier) + "\n    epochClock=" + String.valueOf(this.epochClock) + "\n    errorLog=" + String.valueOf(this.errorLog) + "\n    errorHandler=" + String.valueOf(this.errorHandler) + "\n    delegatingErrorHandler=" + String.valueOf(this.delegatingErrorHandler) + "\n    errorCounter=" + String.valueOf(this.errorCounter) + "\n    countedErrorHandler=" + String.valueOf(this.countedErrorHandler) + "\n    clusteredService=" + String.valueOf(this.clusteredService) + "\n    terminationHook=" + String.valueOf(this.terminationHook) + "\n    cycleThresholdNs=" + this.cycleThresholdNs + "\n    dutyCyleTracker=" + String.valueOf(this.dutyCycleTracker) + "\n    snapshotDurationThresholdNs=" + this.snapshotDurationThresholdNs + "\n    snapshotDurationTracker=" + String.valueOf(this.snapshotDurationTracker) + "\n    markFile=" + String.valueOf(this.markFile) + "\n}";
        }

        static {
            try {
                IS_CONCLUDED_VH = MethodHandles.lookup().findVarHandle(Context.class, "isConcluded", Boolean.TYPE);
            }
            catch (ReflectiveOperationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }

    public static final class Configuration {
        public static final long SNAPSHOT_TYPE_ID = 2L;
        public static final long MARK_FILE_UPDATE_INTERVAL_NS = TimeUnit.SECONDS.toNanos(1L);
        public static final long LIVENESS_TIMEOUT_MS = 10L * TimeUnit.NANOSECONDS.toMillis(MARK_FILE_UPDATE_INTERVAL_NS);
        public static final String CLUSTER_ID_PROP_NAME = "aeron.cluster.id";
        public static final int CLUSTER_ID_DEFAULT = 0;
        public static final String SERVICE_ID_PROP_NAME = "aeron.cluster.service.id";
        public static final int SERVICE_ID_DEFAULT = 0;
        public static final String SERVICE_NAME_PROP_NAME = "aeron.cluster.service.name";
        public static final String SERVICE_NAME_DEFAULT = "clustered-service";
        public static final String SERVICE_CLASS_NAME_PROP_NAME = "aeron.cluster.service.class.name";
        public static final String REPLAY_CHANNEL_PROP_NAME = "aeron.cluster.replay.channel";
        public static final String REPLAY_CHANNEL_DEFAULT = "aeron:ipc";
        public static final String REPLAY_STREAM_ID_PROP_NAME = "aeron.cluster.replay.stream.id";
        public static final int REPLAY_STREAM_ID_DEFAULT = 103;
        public static final String CONTROL_CHANNEL_PROP_NAME = "aeron.cluster.control.channel";
        public static final String CONTROL_CHANNEL_DEFAULT = "aeron:ipc?term-length=128k";
        public static final String SERVICE_STREAM_ID_PROP_NAME = "aeron.cluster.service.stream.id";
        public static final int SERVICE_STREAM_ID_DEFAULT = 104;
        public static final String CONSENSUS_MODULE_STREAM_ID_PROP_NAME = "aeron.cluster.consensus.module.stream.id";
        public static final int CONSENSUS_MODULE_STREAM_ID_DEFAULT = 105;
        public static final String SNAPSHOT_CHANNEL_PROP_NAME = "aeron.cluster.snapshot.channel";
        public static final String SNAPSHOT_CHANNEL_DEFAULT = "aeron:ipc?alias=snapshot";
        public static final String SNAPSHOT_STREAM_ID_PROP_NAME = "aeron.cluster.snapshot.stream.id";
        public static final int SNAPSHOT_STREAM_ID_DEFAULT = 106;
        public static final String CLUSTER_DIR_PROP_NAME = "aeron.cluster.dir";
        public static final String CLUSTER_DIR_DEFAULT = "aeron-cluster";
        public static final String CLUSTER_SERVICES_DIR_PROP_NAME = "aeron.cluster.services.dir";
        public static final String MARK_FILE_DIR_PROP_NAME = "aeron.cluster.mark.file.dir";
        public static final String ERROR_BUFFER_LENGTH_PROP_NAME = "aeron.cluster.service.error.buffer.length";
        public static final int ERROR_BUFFER_LENGTH_DEFAULT = 0x100000;
        public static final String RESPONDER_SERVICE_PROP_NAME = "aeron.cluster.service.responder";
        public static final boolean RESPONDER_SERVICE_DEFAULT = true;
        public static final String LOG_FRAGMENT_LIMIT_PROP_NAME = "aeron.cluster.log.fragment.limit";
        public static final int LOG_FRAGMENT_LIMIT_DEFAULT = 50;
        public static final String DELEGATING_ERROR_HANDLER_PROP_NAME = "aeron.cluster.service.delegating.error.handler";
        public static final String CYCLE_THRESHOLD_PROP_NAME = "aeron.cluster.service.cycle.threshold";
        public static final long CYCLE_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1L);
        public static final String SNAPSHOT_DURATION_THRESHOLD_PROP_NAME = "aeron.cluster.service.snapshot.threshold";
        public static final long SNAPSHOT_DURATION_THRESHOLD_DEFAULT_NS = TimeUnit.MILLISECONDS.toNanos(1000L);
        public static final int CLUSTER_NODE_ROLE_TYPE_ID = 201;
        public static final int COMMIT_POSITION_TYPE_ID = 203;
        public static final int CLUSTERED_SERVICE_ERROR_COUNT_TYPE_ID = 215;
        public static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
        public static final String CLUSTER_IDLE_STRATEGY_PROP_NAME = "aeron.cluster.idle.strategy";
        public static final String STANDBY_SNAPSHOT_ENABLED_PROP_NAME = "aeron.cluster.standby.snapshot.enabled";

        public static int clusterId() {
            return Integer.getInteger(CLUSTER_ID_PROP_NAME, 0);
        }

        public static int serviceId() {
            return Integer.getInteger(SERVICE_ID_PROP_NAME, 0);
        }

        public static String serviceName() {
            return System.getProperty(SERVICE_NAME_PROP_NAME, SERVICE_NAME_DEFAULT);
        }

        public static String replayChannel() {
            return System.getProperty(REPLAY_CHANNEL_PROP_NAME, REPLAY_CHANNEL_DEFAULT);
        }

        public static int replayStreamId() {
            return Integer.getInteger(REPLAY_STREAM_ID_PROP_NAME, 103);
        }

        public static String controlChannel() {
            return System.getProperty(CONTROL_CHANNEL_PROP_NAME, CONTROL_CHANNEL_DEFAULT);
        }

        public static int consensusModuleStreamId() {
            return Integer.getInteger(CONSENSUS_MODULE_STREAM_ID_PROP_NAME, 105);
        }

        public static int serviceStreamId() {
            return Integer.getInteger(SERVICE_STREAM_ID_PROP_NAME, 104);
        }

        public static String snapshotChannel() {
            return System.getProperty(SNAPSHOT_CHANNEL_PROP_NAME, SNAPSHOT_CHANNEL_DEFAULT);
        }

        public static int snapshotStreamId() {
            return Integer.getInteger(SNAPSHOT_STREAM_ID_PROP_NAME, 106);
        }

        public static Supplier<IdleStrategy> idleStrategySupplier(StatusIndicator controllableStatus) {
            return () -> {
                String name = System.getProperty(CLUSTER_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY);
                return io.aeron.driver.Configuration.agentIdleStrategy((String)name, (StatusIndicator)controllableStatus);
            };
        }

        public static String clusterDirName() {
            return System.getProperty(CLUSTER_DIR_PROP_NAME, CLUSTER_DIR_DEFAULT);
        }

        public static String clusterServicesDirName() {
            return System.getProperty(CLUSTER_SERVICES_DIR_PROP_NAME);
        }

        public static int errorBufferLength() {
            return SystemUtil.getSizeAsInt((String)ERROR_BUFFER_LENGTH_PROP_NAME, (int)0x100000);
        }

        public static boolean isRespondingService() {
            String property = System.getProperty(RESPONDER_SERVICE_PROP_NAME);
            if (null == property) {
                return true;
            }
            return "true".equals(property);
        }

        public static int logFragmentLimit() {
            return Integer.getInteger(LOG_FRAGMENT_LIMIT_PROP_NAME, 50);
        }

        public static long cycleThresholdNs() {
            return SystemUtil.getDurationInNanos((String)CYCLE_THRESHOLD_PROP_NAME, (long)CYCLE_THRESHOLD_DEFAULT_NS);
        }

        public static long snapshotDurationThresholdNs() {
            return SystemUtil.getDurationInNanos((String)SNAPSHOT_DURATION_THRESHOLD_PROP_NAME, (long)SNAPSHOT_DURATION_THRESHOLD_DEFAULT_NS);
        }

        public static boolean standbySnapshotEnabled() {
            return Boolean.getBoolean(STANDBY_SNAPSHOT_ENABLED_PROP_NAME);
        }

        public static ClusteredService newClusteredService() {
            String className = System.getProperty(SERVICE_CLASS_NAME_PROP_NAME);
            if (null == className) {
                throw new ClusterException("either a instance or class name for the service must be provided");
            }
            try {
                return (ClusteredService)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
                return null;
            }
        }

        public static DelegatingErrorHandler newDelegatingErrorHandler() {
            String className = System.getProperty(DELEGATING_ERROR_HANDLER_PROP_NAME);
            if (null != className) {
                try {
                    return (DelegatingErrorHandler)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
            }
            return null;
        }

        public static String markFileDir() {
            return System.getProperty(MARK_FILE_DIR_PROP_NAME);
        }
    }
}

