/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.SnapshotMark;
import io.aeron.cluster.codecs.SnapshotMarkerEncoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.logbuffer.BufferClaim;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.IdleStrategy;

public class SnapshotTaker {
    protected final BufferClaim bufferClaim = new BufferClaim();
    protected final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    protected final ExclusivePublication publication;
    protected final IdleStrategy idleStrategy;
    private static final int ENCODED_MARKER_LENGTH = 48;
    private final AgentInvoker aeronAgentInvoker;
    private final SnapshotMarkerEncoder snapshotMarkerEncoder = new SnapshotMarkerEncoder();

    public SnapshotTaker(ExclusivePublication publication, IdleStrategy idleStrategy, AgentInvoker aeronAgentInvoker) {
        this.publication = publication;
        this.idleStrategy = idleStrategy;
        this.aeronAgentInvoker = aeronAgentInvoker;
    }

    public void markBegin(long snapshotTypeId, long logPosition, long leadershipTermId, int snapshotIndex, TimeUnit timeUnit, int appVersion) {
        this.markSnapshot(snapshotTypeId, logPosition, leadershipTermId, snapshotIndex, SnapshotMark.BEGIN, timeUnit, appVersion);
    }

    public void markEnd(long snapshotTypeId, long logPosition, long leadershipTermId, int snapshotIndex, TimeUnit timeUnit, int appVersion) {
        this.markSnapshot(snapshotTypeId, logPosition, leadershipTermId, snapshotIndex, SnapshotMark.END, timeUnit, appVersion);
    }

    public void markSnapshot(long snapshotTypeId, long logPosition, long leadershipTermId, int snapshotIndex, SnapshotMark snapshotMark, TimeUnit timeUnit, int appVersion) {
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(48, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.snapshotMarkerEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).typeId(snapshotTypeId).logPosition(logPosition).leadershipTermId(leadershipTermId).index(snapshotIndex).mark(snapshotMark).timeUnit(ClusterClock.map(timeUnit)).appVersion(appVersion);
        this.bufferClaim.commit();
    }

    protected static void checkInterruptStatus() {
        if (Thread.currentThread().isInterrupted()) {
            throw new AgentTerminationException("interrupted");
        }
    }

    protected static void checkResult(long position, Publication publication) {
        if (-1L == position) {
            throw new ClusterException("publication is not connected");
        }
        if (-4L == position) {
            throw new ClusterException("publication is closed");
        }
        if (-5L == position) {
            throw new ClusterException("publication at max position: term-length=" + publication.termBufferLength());
        }
    }

    protected void checkResultAndIdle(long position) {
        SnapshotTaker.checkResult(position, (Publication)this.publication);
        SnapshotTaker.checkInterruptStatus();
        this.invokeAgentClient();
        this.idleStrategy.idle();
    }

    protected void invokeAgentClient() {
        if (null != this.aeronAgentInvoker) {
            this.aeronAgentInvoker.invoke();
        }
    }

    protected final void offer(DirectBuffer buffer, int offset, int length) {
        long result;
        this.idleStrategy.reset();
        while ((result = this.publication.offer(buffer, offset, length)) <= 0L) {
            this.checkResultAndIdle(result);
        }
    }
}

