/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;


/**
 * Type of Cluster Change Event.
 */
@SuppressWarnings("all")
public enum ChangeType
{

    /**
     * Join cluster as dynamic member.
     */
    JOIN(0),


    /**
     * Quit cluster as dynamic member.
     */
    QUIT(1),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ChangeType(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static ChangeType get(final int value)
    {
        switch (value)
        {
            case 0: return JOIN;
            case 1: return QUIT;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
