/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.Image;
import io.aeron.cluster.ClusterMembership;
import io.aeron.cluster.ClusterToolCommand;
import io.aeron.cluster.ClusterToolOperator;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusterNodeControlProperties;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.agrona.SystemUtil;
import org.agrona.collections.Object2ObjectHashMap;

public class ClusterTool {
    public static final String AERON_CLUSTER_TOOL_TIMEOUT_PROP_NAME = "aeron.cluster.tool.timeout";
    public static final String AERON_CLUSTER_TOOL_DELAY_PROP_NAME = "aeron.cluster.tool.delay";
    public static final String AERON_CLUSTER_TOOL_REPLAY_CHANNEL_PROP_NAME = "aeron.cluster.tool.replay.channel";
    public static final String AERON_CLUSTER_TOOL_REPLAY_CHANNEL_DEFAULT = "aeron:ipc";
    public static final String AERON_CLUSTER_TOOL_REPLAY_CHANNEL = SystemUtil.getProperty((String)"aeron.cluster.tool.replay.channel", (String)"aeron:ipc");
    public static final String AERON_CLUSTER_TOOL_REPLAY_STREAM_ID_PROP_NAME = "aeron.cluster.tool.replay.stream.id";
    public static final int AERON_CLUSTER_TOOL_REPLAY_STREAM_ID_DEFAULT = 103;
    public static final int AERON_CLUSTER_TOOL_REPLAY_STREAM_ID = Integer.getInteger("aeron.cluster.tool.replay.stream.id", 103);
    public static final long TIMEOUT_MS = TimeUnit.NANOSECONDS.toMillis(SystemUtil.getDurationInNanos((String)"aeron.cluster.tool.timeout", (long)0L));
    private static final ClusterToolOperator BACKWARD_COMPATIBLE_OPERATIONS = new ClusterToolOperator(AERON_CLUSTER_TOOL_REPLAY_CHANNEL, AERON_CLUSTER_TOOL_REPLAY_STREAM_ID, TIMEOUT_MS);
    private static final String HELP_PREFIX = "Usage: <cluster-dir> <command> [options]";
    private static final Object2ObjectHashMap<String, ClusterToolCommand> COMMANDS = new Object2ObjectHashMap();

    public static void main(String[] args) {
        ClusterToolCommand command;
        File clusterDir;
        if (args.length < 2) {
            ClusterToolCommand.printHelp(COMMANDS, HELP_PREFIX);
            System.exit(-1);
        }
        if (!(clusterDir = new File(args[0])).exists()) {
            System.err.println("ERR: cluster directory not found: " + clusterDir.getAbsolutePath());
            ClusterToolCommand.printHelp(COMMANDS, HELP_PREFIX);
            System.exit(-1);
        }
        if (null == (command = (ClusterToolCommand)COMMANDS.get((Object)args[1]))) {
            System.out.println("Unknown command: " + args[1]);
            ClusterToolCommand.printHelp(COMMANDS, HELP_PREFIX);
            System.exit(-1);
        } else {
            int status = command.action().act(clusterDir, System.out, args);
            if (0 != status) {
                System.exit(status);
            }
        }
    }

    public static void describe(PrintStream out, File clusterDir) {
        BACKWARD_COMPATIBLE_OPERATIONS.describeClusterMarkFile(clusterDir, out);
    }

    public static void pid(PrintStream out, File clusterDir) {
        BACKWARD_COMPATIBLE_OPERATIONS.pid(clusterDir, out);
    }

    public static void recoveryPlan(PrintStream out, File clusterDir, int serviceCount) {
        BACKWARD_COMPATIBLE_OPERATIONS.recoveryPlan(out, clusterDir, serviceCount);
    }

    public static void recordingLog(PrintStream out, File clusterDir) {
        BACKWARD_COMPATIBLE_OPERATIONS.recordingLog(clusterDir, out);
    }

    public static boolean sortRecordingLog(File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.sortRecordingLog(clusterDir) == 0;
    }

    public static void seedRecordingLogFromSnapshot(File clusterDir) {
        BACKWARD_COMPATIBLE_OPERATIONS.seedRecordingLogFromSnapshot(clusterDir);
    }

    public static void errors(PrintStream out, File clusterDir) {
        BACKWARD_COMPATIBLE_OPERATIONS.errors(clusterDir, out);
    }

    public static void listMembers(PrintStream out, File clusterDir) {
        BACKWARD_COMPATIBLE_OPERATIONS.listMembers(clusterDir, out);
    }

    public static void printNextBackupQuery(PrintStream out, File clusterDir) {
        BACKWARD_COMPATIBLE_OPERATIONS.printNextBackupQuery(clusterDir, out);
    }

    public static void nextBackupQuery(PrintStream out, File clusterDir, long delayMs) {
        BACKWARD_COMPATIBLE_OPERATIONS.nextBackupQuery(clusterDir, out, delayMs);
    }

    public static void describe(PrintStream out, ClusterMarkFile[] serviceMarkFiles) {
        BACKWARD_COMPATIBLE_OPERATIONS.describe(out, serviceMarkFiles);
    }

    public static int isLeader(PrintStream out, File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.isLeader(clusterDir, out);
    }

    public static boolean markFileExists(File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.markFileExists(clusterDir);
    }

    public static boolean listMembers(ClusterMembership clusterMembership, File clusterDir, long timeoutMs) {
        return BACKWARD_COMPATIBLE_OPERATIONS.listMembers(clusterMembership, clusterDir, timeoutMs);
    }

    public static boolean queryClusterMembers(ClusterMarkFile markFile, long timeoutMs, ClusterMembership clusterMembership) {
        return BACKWARD_COMPATIBLE_OPERATIONS.queryClusterMembers(markFile, timeoutMs, clusterMembership);
    }

    public static boolean queryClusterMembers(ClusterNodeControlProperties controlProperties, long timeoutMs, ClusterMembership clusterMembership) {
        return BACKWARD_COMPATIBLE_OPERATIONS.queryClusterMembers(controlProperties, timeoutMs, clusterMembership);
    }

    public static long nextBackupQueryDeadlineMs(File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.nextBackupQueryDeadlineMs(clusterDir);
    }

    public static long nextBackupQueryDeadlineMs(ClusterMarkFile markFile) {
        return BACKWARD_COMPATIBLE_OPERATIONS.nextBackupQueryDeadlineMs(markFile);
    }

    public static boolean nextBackupQueryDeadlineMs(File clusterDir, long timeMs) {
        return BACKWARD_COMPATIBLE_OPERATIONS.nextBackupQueryDeadlineMs(clusterDir, timeMs);
    }

    public static boolean nextBackupQueryDeadlineMs(ClusterMarkFile markFile, long timeMs) {
        return BACKWARD_COMPATIBLE_OPERATIONS.nextBackupQueryDeadlineMs(markFile, timeMs);
    }

    public static boolean invalidateLatestSnapshot(PrintStream out, File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.invalidateLatestSnapshot(clusterDir, out) == 0;
    }

    public static boolean describeLatestConsensusModuleSnapshot(PrintStream out, File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.describeLatestConsensusModuleSnapshot(clusterDir, out, null) == 0;
    }

    public static boolean describeLatestConsensusModuleSnapshot(PrintStream out, File clusterDir, BiConsumer<Image, Aeron> postConsensusImageDescriber) {
        return BACKWARD_COMPATIBLE_OPERATIONS.describeLatestConsensusModuleSnapshot(clusterDir, out, null) == 0;
    }

    public static boolean snapshot(File clusterDir, PrintStream out) {
        return BACKWARD_COMPATIBLE_OPERATIONS.snapshot(clusterDir, out) == 0;
    }

    public static boolean suspend(File clusterDir, PrintStream out) {
        return BACKWARD_COMPATIBLE_OPERATIONS.suspend(clusterDir, out) == 0;
    }

    public static boolean resume(File clusterDir, PrintStream out) {
        return BACKWARD_COMPATIBLE_OPERATIONS.resume(clusterDir, out) == 0;
    }

    public static boolean shutdown(File clusterDir, PrintStream out) {
        return BACKWARD_COMPATIBLE_OPERATIONS.shutdown(clusterDir, out) == 0;
    }

    public static boolean abort(File clusterDir, PrintStream out) {
        return BACKWARD_COMPATIBLE_OPERATIONS.abort(clusterDir, out) == 0;
    }

    static RecordingLog.Entry findLatestValidSnapshot(File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.findLatestValidSnapshot(clusterDir);
    }

    static ClusterNodeControlProperties loadControlProperties(File clusterDir) {
        return BACKWARD_COMPATIBLE_OPERATIONS.loadControlProperties(clusterDir);
    }

    public static Map<String, ClusterToolCommand> commands() {
        return new Object2ObjectHashMap(COMMANDS);
    }

    static {
        ClusterToolOperator operator = new ClusterToolOperator(AERON_CLUSTER_TOOL_REPLAY_CHANNEL, AERON_CLUSTER_TOOL_REPLAY_STREAM_ID, TIMEOUT_MS);
        COMMANDS.put((Object)"describe", (Object)new ClusterToolCommand(ClusterToolCommand.ignoreFailures(ClusterToolCommand.action(operator::describeClusterMarkFile)), "prints out all descriptors in the mark file."));
        COMMANDS.put((Object)"pid", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::pid), "prints PID of cluster component."));
        COMMANDS.put((Object)"recovery-plan", (Object)new ClusterToolCommand((clusterDir, out, args) -> {
            if (args.length < 3) {
                ClusterToolCommand.printHelp(COMMANDS, HELP_PREFIX);
                return -1;
            }
            return operator.recoveryPlan(System.out, clusterDir, Integer.parseInt(args[2]));
        }, "[service count] prints recovery plan of cluster component."));
        COMMANDS.put((Object)"recording-log", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::recordingLog), "prints recording log of cluster component."));
        COMMANDS.put((Object)"sort-recording-log", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::sortRecordingLog), "reorders entries in the recording log to match the order in memory."));
        COMMANDS.put((Object)"seed-recording-log-from-snapshot", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::seedRecordingLogFromSnapshot), "creates a new recording log based on the latest valid snapshot."));
        COMMANDS.put((Object)"errors", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::errors), "prints Aeron and cluster component error logs."));
        COMMANDS.put((Object)"list-members", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::listMembers), "prints leader memberId and active members."));
        COMMANDS.put((Object)"backup-query", (Object)new ClusterToolCommand((clusterDir, out, args) -> {
            if (args.length < 3) {
                return operator.printNextBackupQuery(clusterDir, System.out);
            }
            return operator.nextBackupQuery(clusterDir, System.out, TimeUnit.NANOSECONDS.toMillis(SystemUtil.parseDuration((String)AERON_CLUSTER_TOOL_DELAY_PROP_NAME, (String)args[2])));
        }, "[delay] get, or set, time of next backup query."));
        COMMANDS.put((Object)"invalidate-latest-snapshot", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::invalidateLatestSnapshot), "marks the latest snapshot as a invalid so the previous is loaded."));
        COMMANDS.put((Object)"is-leader", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::isLeader), "returns zero if the cluster node is leader, non-zero if not."));
        COMMANDS.put((Object)"snapshot", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::snapshot), "triggers a snapshot on the leader."));
        COMMANDS.put((Object)"suspend", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::suspend), "suspends appending to the log."));
        COMMANDS.put((Object)"resume", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::resume), "resumes appending to the log."));
        COMMANDS.put((Object)"shutdown", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::shutdown), "initiates an orderly stop of the cluster with a snapshot."));
        COMMANDS.put((Object)"abort", (Object)new ClusterToolCommand(ClusterToolCommand.action(operator::abort), "stops the cluster without a snapshot."));
        COMMANDS.put((Object)"describe-latest-cm-snapshot", (Object)new ClusterToolCommand(ClusterToolCommand.action((clusterDir, listener) -> operator.describeLatestConsensusModuleSnapshot((File)clusterDir, (PrintStream)listener, null)), "prints the contents of the latest valid consensus module snapshot."));
    }
}

