/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ReplicationParams;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.RecordingReplication;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.collections.Long2LongHashMap;

final class MultipleRecordingReplication
implements AutoCloseable {
    private final AeronArchive archive;
    private final int srcControlStreamId;
    private final String srcControlChannel;
    private final String replicationChannel;
    private final String srcResponseChannel;
    private final ArrayList<RecordingInfo> recordingsPending = new ArrayList();
    private final Long2LongHashMap recordingsCompleted = new Long2LongHashMap(-1L);
    private final long progressTimeoutNs;
    private final long progressIntervalNs;
    private int recordingCursor = 0;
    private RecordingReplication recordingReplication = null;
    private EventListener eventListener = null;

    private MultipleRecordingReplication(AeronArchive archive, int srcControlStreamId, String srcControlChannel, String replicationChannel, String srcResponseChannel, long replicationProgressTimeoutNs, long replicationProgressIntervalNs) {
        this.archive = archive;
        this.srcControlStreamId = srcControlStreamId;
        this.srcControlChannel = srcControlChannel;
        this.replicationChannel = replicationChannel;
        this.srcResponseChannel = srcResponseChannel;
        this.progressTimeoutNs = replicationProgressTimeoutNs;
        this.progressIntervalNs = replicationProgressIntervalNs;
    }

    static MultipleRecordingReplication newInstance(AeronArchive archive, int srcControlStreamId, String srcControlChannel, String replicationChannel, long replicationProgressTimeoutNs, long replicationProgressIntervalNs) {
        return new MultipleRecordingReplication(archive, srcControlStreamId, srcControlChannel, replicationChannel, null, replicationProgressTimeoutNs, replicationProgressIntervalNs);
    }

    static MultipleRecordingReplication newInstance(AeronArchive archive, int srcControlStreamId, String srcControlChannel, String replicationChannel, String srcResponseChannel, long replicationProgressTimeoutNs, long replicationProgressIntervalNs) {
        return new MultipleRecordingReplication(archive, srcControlStreamId, srcControlChannel, replicationChannel, srcResponseChannel, replicationProgressTimeoutNs, replicationProgressIntervalNs);
    }

    void addRecording(long srcRecordingId, long dstRecordingId, long stopPosition) {
        this.recordingsPending.add(new RecordingInfo(srcRecordingId, dstRecordingId, stopPosition));
    }

    int poll(long nowNs) {
        if (this.isComplete()) {
            return 0;
        }
        int workDone = 0;
        if (null == this.recordingReplication) {
            this.replicateCurrentSnapshot(nowNs);
            ++workDone;
        } else {
            this.recordingReplication.poll(nowNs);
            if (this.recordingReplication.hasReplicationEnded()) {
                RecordingInfo pending = this.recordingsPending.get(this.recordingCursor);
                this.onReplicationEnded(this.srcControlChannel, pending.srcRecordingId, this.recordingReplication.recordingId(), this.recordingReplication.position(), this.recordingReplication.hasSynced());
                if (this.recordingReplication.hasSynced()) {
                    this.recordingsCompleted.put(pending.srcRecordingId, this.recordingReplication.recordingId());
                    ++this.recordingCursor;
                    replication = this.recordingReplication;
                    this.recordingReplication = null;
                    CloseHelper.close((AutoCloseable)replication);
                } else {
                    replication = this.recordingReplication;
                    this.recordingReplication = null;
                    CloseHelper.close((AutoCloseable)replication);
                    this.replicateCurrentSnapshot(nowNs);
                }
                ++workDone;
            }
        }
        return workDone;
    }

    long completedDstRecordingId(long srcRecordingId) {
        return this.recordingsCompleted.get(srcRecordingId);
    }

    void onSignal(long correlationId, long recordingId, long position, RecordingSignal signal) {
        if (null != this.recordingReplication) {
            this.recordingReplication.onSignal(correlationId, recordingId, position, signal);
        }
    }

    boolean isComplete() {
        return this.recordingCursor >= this.recordingsPending.size();
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.recordingReplication);
        this.recordingReplication = null;
    }

    private void replicateCurrentSnapshot(long nowNs) {
        RecordingInfo recordingInfo = this.recordingsPending.get(this.recordingCursor);
        ReplicationParams replicationParams = new ReplicationParams().dstRecordingId(recordingInfo.dstRecordingId).stopPosition(recordingInfo.stopPosition).replicationChannel(this.replicationChannel).srcResponseChannel(this.srcResponseChannel).replicationSessionId((int)this.archive.context().aeron().nextCorrelationId());
        this.recordingReplication = new RecordingReplication(this.archive, recordingInfo.srcRecordingId, this.srcControlChannel, this.srcControlStreamId, replicationParams, this.progressTimeoutNs, this.progressIntervalNs, nowNs);
    }

    private void onReplicationEnded(String srcArchiveControlChannel, long srcRecordingId, long dstRecordingId, long position, boolean hasSynced) {
        if (null != this.eventListener) {
            this.eventListener.onReplicationEnded(srcArchiveControlChannel, srcRecordingId, dstRecordingId, position, hasSynced);
        }
    }

    void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    static interface EventListener {
        public void onReplicationEnded(String var1, long var2, long var4, long var6, boolean var8);
    }

    static final class RecordingInfo {
        private final long srcRecordingId;
        private final long dstRecordingId;
        private final long stopPosition;

        private RecordingInfo(long srcRecordingId, long dstRecordingId, long stopPosition) {
            this.srcRecordingId = srcRecordingId;
            this.dstRecordingId = dstRecordingId;
            this.stopPosition = stopPosition;
        }
    }
}

