/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.TimerService;
import io.aeron.cluster.TimerServiceSupplier;
import io.aeron.cluster.WheelTimerService;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;

public class WheelTimerServiceSupplier
implements TimerServiceSupplier {
    private final TimeUnit timeUnit;
    private final long startTime;
    private final long tickResolution;
    private final int ticksPerWheel;

    public WheelTimerServiceSupplier(TimeUnit timeUnit, long startTime, long tickResolution, int ticksPerWheel) {
        this.timeUnit = timeUnit;
        this.startTime = startTime;
        this.tickResolution = tickResolution;
        this.ticksPerWheel = ticksPerWheel;
    }

    @Override
    public TimerService newInstance(TimeUnit clusterTimeUnit, TimerService.TimerHandler timerHandler) {
        long startTimeInClusterTimeUnits = clusterTimeUnit.convert(this.startTime, this.timeUnit);
        long resolutionInClusterTimeUnits = clusterTimeUnit.convert(this.tickResolution, this.timeUnit);
        return new WheelTimerService(timerHandler, clusterTimeUnit, startTimeInClusterTimeUnits, BitUtil.findNextPositivePowerOfTwo((long)resolutionInClusterTimeUnits), this.ticksPerWheel);
    }
}

