/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.ChangeType;
import io.aeron.cluster.codecs.MembershipChangeEventDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class MembershipChangeEventEncoder {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 25;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 14;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final MembershipChangeEventEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 25;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 14;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public MembershipChangeEventEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 40);
        return this;
    }

    public MembershipChangeEventEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(40).templateId(25).schemaId(111).version(14);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int leadershipTermIdId() {
        return 1;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public MembershipChangeEventEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public MembershipChangeEventEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int timestampId() {
        return 3;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public MembershipChangeEventEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int leaderMemberIdId() {
        return 4;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 24;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MembershipChangeEventEncoder leaderMemberId(int value) {
        this.buffer.putInt(this.offset + 24, value, BYTE_ORDER);
        return this;
    }

    public static int clusterSizeId() {
        return 5;
    }

    public static int clusterSizeSinceVersion() {
        return 0;
    }

    public static int clusterSizeEncodingOffset() {
        return 28;
    }

    public static int clusterSizeEncodingLength() {
        return 4;
    }

    public static String clusterSizeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int clusterSizeNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int clusterSizeMinValue() {
        return -2147483647;
    }

    public static int clusterSizeMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MembershipChangeEventEncoder clusterSize(int value) {
        this.buffer.putInt(this.offset + 28, value, BYTE_ORDER);
        return this;
    }

    public static int changeTypeId() {
        return 6;
    }

    public static int changeTypeSinceVersion() {
        return 0;
    }

    public static int changeTypeEncodingOffset() {
        return 32;
    }

    public static int changeTypeEncodingLength() {
        return 4;
    }

    public static String changeTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public MembershipChangeEventEncoder changeType(ChangeType value) {
        this.buffer.putInt(this.offset + 32, value.value(), BYTE_ORDER);
        return this;
    }

    public static int memberIdId() {
        return 7;
    }

    public static int memberIdSinceVersion() {
        return 0;
    }

    public static int memberIdEncodingOffset() {
        return 36;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MembershipChangeEventEncoder memberId(int value) {
        this.buffer.putInt(this.offset + 36, value, BYTE_ORDER);
        return this;
    }

    public static int clusterMembersId() {
        return 8;
    }

    public static String clusterMembersCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String clusterMembersMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int clusterMembersHeaderLength() {
        return 4;
    }

    public MembershipChangeEventEncoder putClusterMembers(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MembershipChangeEventEncoder putClusterMembers(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public MembershipChangeEventEncoder clusterMembers(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public MembershipChangeEventEncoder clusterMembers(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        MembershipChangeEventDecoder decoder = new MembershipChangeEventDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 40, 14);
        return decoder.appendTo(builder);
    }
}

