/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs.node;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class MessageHeaderDecoder {
    public static final int SCHEMA_ID = 112;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.3";
    public static final int ENCODED_LENGTH = 16;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public MessageHeaderDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 16;
    }

    public int sbeSchemaId() {
        return 112;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthSinceVersion() {
        return 0;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public int blockLength() {
        return this.buffer.getShort(this.offset + 0, BYTE_ORDER) & 0xFFFF;
    }

    public static int templateIdEncodingOffset() {
        return 2;
    }

    public static int templateIdEncodingLength() {
        return 2;
    }

    public static int templateIdSinceVersion() {
        return 0;
    }

    public static int templateIdNullValue() {
        return 65535;
    }

    public static int templateIdMinValue() {
        return 0;
    }

    public static int templateIdMaxValue() {
        return 65534;
    }

    public int templateId() {
        return this.buffer.getShort(this.offset + 2, BYTE_ORDER) & 0xFFFF;
    }

    public static int schemaIdEncodingOffset() {
        return 4;
    }

    public static int schemaIdEncodingLength() {
        return 2;
    }

    public static int schemaIdSinceVersion() {
        return 0;
    }

    public static int schemaIdNullValue() {
        return 65535;
    }

    public static int schemaIdMinValue() {
        return 0;
    }

    public static int schemaIdMaxValue() {
        return 65534;
    }

    public int schemaId() {
        return this.buffer.getShort(this.offset + 4, BYTE_ORDER) & 0xFFFF;
    }

    public static int versionEncodingOffset() {
        return 6;
    }

    public static int versionEncodingLength() {
        return 2;
    }

    public static int versionSinceVersion() {
        return 0;
    }

    public static int versionNullValue() {
        return 65535;
    }

    public static int versionMinValue() {
        return 0;
    }

    public static int versionMaxValue() {
        return 65534;
    }

    public int version() {
        return this.buffer.getShort(this.offset + 6, BYTE_ORDER) & 0xFFFF;
    }

    public static int frameLengthEncodingOffset() {
        return 8;
    }

    public static int frameLengthEncodingLength() {
        return 4;
    }

    public static int frameLengthSinceVersion() {
        return 0;
    }

    public static int frameLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int frameLengthMinValue() {
        return -2147483647;
    }

    public static int frameLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int frameLength() {
        return this.buffer.getInt(this.offset + 8, BYTE_ORDER);
    }

    public static int paddingEncodingOffset() {
        return 12;
    }

    public static int paddingEncodingLength() {
        return 4;
    }

    public static int paddingSinceVersion() {
        return 0;
    }

    public static int paddingNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int paddingMinValue() {
        return -2147483647;
    }

    public static int paddingMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int padding() {
        return this.buffer.getInt(this.offset + 12, BYTE_ORDER);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("blockLength=");
        builder.append(this.blockLength());
        builder.append('|');
        builder.append("templateId=");
        builder.append(this.templateId());
        builder.append('|');
        builder.append("schemaId=");
        builder.append(this.schemaId());
        builder.append('|');
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("frameLength=");
        builder.append(this.frameLength());
        builder.append('|');
        builder.append("padding=");
        builder.append(this.padding());
        builder.append(')');
        return builder;
    }
}

