/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.CommonContext;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.cluster.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.cluster.codecs.mark.MessageHeaderDecoder;
import io.aeron.cluster.codecs.mark.MessageHeaderEncoder;
import io.aeron.cluster.codecs.mark.VarAsciiEncodingEncoder;
import io.aeron.cluster.service.ClusterNodeControlProperties;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.MarkFile;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public final class ClusterMarkFile
implements AutoCloseable {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 3;
    public static final int PATCH_VERSION = 0;
    public static final int SEMANTIC_VERSION = SemanticVersion.compose((int)0, (int)3, (int)0);
    public static final int HEADER_LENGTH = 8192;
    public static final int VERSION_FAILED = -1;
    public static final int ERROR_BUFFER_MIN_LENGTH = 0x100000;
    public static final int ERROR_BUFFER_MAX_LENGTH = 0x7FFFDFFF;
    public static final String FILE_EXTENSION = ".dat";
    public static final String LINK_FILE_EXTENSION = ".lnk";
    public static final String FILENAME = "cluster-mark.dat";
    public static final String LINK_FILENAME = "cluster-mark.lnk";
    public static final String SERVICE_FILENAME_PREFIX = "cluster-mark-service-";
    private static final UnsafeBuffer EMPTY_BUFFER = new UnsafeBuffer(0L, 0);
    private static final int HEADER_OFFSET = 8;
    private final MarkFileHeaderDecoder headerDecoder = new MarkFileHeaderDecoder();
    private final MarkFileHeaderEncoder headerEncoder = new MarkFileHeaderEncoder();
    private final MarkFile markFile;
    private final UnsafeBuffer buffer;
    private final UnsafeBuffer errorBuffer;
    private final int headerOffset;

    @Deprecated(forRemoval=true)
    public ClusterMarkFile(File file, ClusterComponentType type, int errorBufferLength, EpochClock epochClock, long timeoutMs) {
        this(file, type, errorBufferLength, epochClock, timeoutMs, 4096);
    }

    public ClusterMarkFile(File file, ClusterComponentType type, int errorBufferLength, EpochClock epochClock, long timeoutMs, int filePageSize) {
        long candidateTermId;
        if (errorBufferLength < 0x100000 || errorBufferLength > 0x7FFFDFFF) {
            throw new IllegalArgumentException("Invalid errorBufferLength: " + errorBufferLength);
        }
        LogBufferDescriptor.checkPageSize((int)filePageSize);
        boolean markFileExists = file.exists();
        int totalFileLength = BitUtil.align((int)(8192 + errorBufferLength), (int)filePageSize);
        MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
        if (markFileExists) {
            int currentHeaderOffset = ClusterMarkFile.headerOffset(file);
            MarkFile existingMarkFile = new MarkFile(file, true, currentHeaderOffset + MarkFileHeaderDecoder.versionEncodingOffset(), currentHeaderOffset + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, version -> {
                if (-1 == version) {
                    System.err.println("mark file version -1 indicates error on previous startup.");
                } else if (SemanticVersion.major((int)version) != 0) {
                    throw new ClusterException("mark file major version " + SemanticVersion.major((int)version) + " does not match software: 0");
                }
            }, null);
            UnsafeBuffer existingBuffer = existingMarkFile.buffer();
            if (0 != currentHeaderOffset) {
                this.headerDecoder.wrapAndApplyHeader((DirectBuffer)existingBuffer, 0, messageHeaderDecoder);
            } else {
                this.headerDecoder.wrap((DirectBuffer)existingBuffer, 0, 128, 2);
            }
            ClusterComponentType existingType = this.headerDecoder.componentType();
            if (existingType != ClusterComponentType.UNKNOWN && existingType != type && (existingType != ClusterComponentType.BACKUP || ClusterComponentType.CONSENSUS_MODULE != type)) {
                throw new ClusterException("existing Mark file type " + String.valueOf((Object)existingType) + " not same as required type " + String.valueOf((Object)type));
            }
            int existingErrorBufferLength = this.headerDecoder.errorBufferLength();
            int headerLength = this.headerDecoder.headerLength();
            UnsafeBuffer existingErrorBuffer = new UnsafeBuffer((DirectBuffer)existingBuffer, headerLength, existingErrorBufferLength);
            ClusterMarkFile.saveExistingErrors(file, (AtomicBuffer)existingErrorBuffer, type, CommonContext.fallbackLogger());
            existingErrorBuffer.setMemory(0, existingErrorBufferLength, (byte)0);
            candidateTermId = this.headerDecoder.candidateTermId();
            if (0 != currentHeaderOffset) {
                this.markFile = existingMarkFile;
                this.buffer = existingBuffer;
            } else {
                this.headerDecoder.wrap((DirectBuffer)EMPTY_BUFFER, 0, 0, 0);
                CloseHelper.close((AutoCloseable)existingMarkFile);
                this.markFile = new MarkFile(file, true, 8 + MarkFileHeaderDecoder.versionEncodingOffset(), 8 + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, version -> {}, null);
                this.buffer = this.markFile.buffer();
                this.buffer.setMemory(0, headerLength, (byte)0);
            }
        } else {
            this.markFile = new MarkFile(file, false, 8 + MarkFileHeaderDecoder.versionEncodingOffset(), 8 + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, version -> {}, null);
            this.buffer = this.markFile.buffer();
            candidateTermId = -1L;
        }
        this.headerOffset = 8;
        this.errorBuffer = new UnsafeBuffer((DirectBuffer)this.buffer, 8192, errorBufferLength);
        this.headerEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, new MessageHeaderEncoder()).componentType(type).startTimestamp(epochClock.time()).pid(SystemUtil.getPid()).candidateTermId(candidateTermId).headerLength(8192).errorBufferLength(errorBufferLength);
        this.headerDecoder.wrapAndApplyHeader((DirectBuffer)this.buffer, 0, messageHeaderDecoder);
    }

    public ClusterMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, Consumer<String> logger) {
        this(ClusterMarkFile.openExistingMarkFile(directory, filename, epochClock, timeoutMs, logger));
    }

    ClusterMarkFile(MarkFile markFile) {
        this.markFile = markFile;
        this.buffer = markFile.buffer();
        this.headerOffset = ClusterMarkFile.headerOffset(this.buffer);
        if (0 != this.headerOffset) {
            this.headerEncoder.wrap((MutableDirectBuffer)this.buffer, this.headerOffset);
            this.headerDecoder.wrapAndApplyHeader((DirectBuffer)this.buffer, 0, new MessageHeaderDecoder());
        } else {
            this.headerEncoder.wrap((MutableDirectBuffer)this.buffer, 0);
            this.headerDecoder.wrap((DirectBuffer)this.buffer, 0, 128, 2);
        }
        this.errorBuffer = new UnsafeBuffer((DirectBuffer)this.buffer, this.headerDecoder.headerLength(), this.headerDecoder.errorBufferLength());
    }

    public File parentDirectory() {
        return this.markFile.parentDirectory();
    }

    public static boolean isServiceMarkFile(Path path, BasicFileAttributes attributes) {
        String fileName = path.getFileName().toString();
        return fileName.startsWith(SERVICE_FILENAME_PREFIX) && fileName.endsWith(FILE_EXTENSION);
    }

    public static boolean isConsensusModuleMarkFile(Path path, BasicFileAttributes attributes) {
        return path.getFileName().toString().equals(FILENAME);
    }

    @Override
    public void close() {
        if (!this.markFile.isClosed()) {
            this.headerEncoder.wrap((MutableDirectBuffer)EMPTY_BUFFER, 0);
            this.headerDecoder.wrap((DirectBuffer)EMPTY_BUFFER, 0, 0, 0);
            this.errorBuffer.wrap(0L, 0);
            CloseHelper.close((AutoCloseable)this.markFile);
        }
    }

    public boolean isClosed() {
        return this.markFile.isClosed();
    }

    public long candidateTermId() {
        return this.markFile.isClosed() ? -1L : this.buffer.getLongVolatile(this.headerOffset + MarkFileHeaderDecoder.candidateTermIdEncodingOffset());
    }

    public int memberId() {
        return this.markFile.isClosed() ? -1 : this.headerDecoder.memberId();
    }

    public void memberId(int memberId) {
        if (!this.markFile.isClosed()) {
            this.headerEncoder.memberId(memberId);
        }
    }

    public int clusterId() {
        return this.markFile.isClosed() ? -1 : this.headerDecoder.clusterId();
    }

    public void clusterId(int clusterId) {
        if (!this.markFile.isClosed()) {
            this.headerEncoder.clusterId(clusterId);
        }
    }

    @Deprecated(forRemoval=true)
    public void signalReady() {
        if (!this.markFile.isClosed()) {
            this.markFile.signalReady(SEMANTIC_VERSION);
        }
    }

    public void signalReady(long activityTimestamp) {
        this.signalReady(SEMANTIC_VERSION, activityTimestamp);
    }

    public void signalFailedStart() {
        this.signalReady(-1, -1L);
    }

    public void signalTerminated() {
        if (!this.markFile.isClosed()) {
            this.markFile.timestampRelease(-1L);
            this.force();
        }
    }

    public void updateActivityTimestamp(long nowMs) {
        if (!this.markFile.isClosed()) {
            this.markFile.timestampRelease(nowMs);
        }
    }

    public long activityTimestampVolatile() {
        return this.markFile.isClosed() ? -1L : this.markFile.timestampVolatile();
    }

    public MarkFileHeaderEncoder encoder() {
        return this.headerEncoder;
    }

    public MarkFileHeaderDecoder decoder() {
        return this.headerDecoder;
    }

    public AtomicBuffer errorBuffer() {
        return this.errorBuffer;
    }

    public static void saveExistingErrors(File markFile, AtomicBuffer errorBuffer, ClusterComponentType type, PrintStream logger) {
        CommonContext.saveExistingErrors((File)markFile, (AtomicBuffer)errorBuffer, (PrintStream)logger, (String)type.name());
    }

    public static void checkHeaderLength(String aeronDirectory, String controlChannel, String ingressChannel, String serviceName, String authenticator) {
        int length = 136 + 5 * VarAsciiEncodingEncoder.lengthEncodingLength() + (null == aeronDirectory ? 0 : aeronDirectory.length()) + (null == controlChannel ? 0 : controlChannel.length()) + (null == ingressChannel ? 0 : ingressChannel.length()) + (null == serviceName ? 0 : serviceName.length()) + (null == authenticator ? 0 : authenticator.length());
        if (length > 8192) {
            throw new ClusterException("ClusterMarkFile headerLength=" + length + " > headerLengthCapacity=8192");
        }
    }

    public static String markFilenameForService(int serviceId) {
        return SERVICE_FILENAME_PREFIX + serviceId + FILE_EXTENSION;
    }

    public static String linkFilenameForService(int serviceId) {
        return SERVICE_FILENAME_PREFIX + serviceId + LINK_FILE_EXTENSION;
    }

    public ClusterNodeControlProperties loadControlProperties() {
        if (!this.markFile.isClosed()) {
            this.headerDecoder.sbeRewind();
            return new ClusterNodeControlProperties(this.headerDecoder.memberId(), this.headerDecoder.serviceStreamId(), this.headerDecoder.consensusModuleStreamId(), this.headerDecoder.aeronDirectory(), this.headerDecoder.controlChannel());
        }
        return null;
    }

    public void force() {
        if (!this.markFile.isClosed()) {
            MappedByteBuffer mappedByteBuffer = this.markFile.mappedByteBuffer();
            mappedByteBuffer.force();
        }
    }

    public String toString() {
        return "ClusterMarkFile{semanticVersion=" + SemanticVersion.toString((int)SEMANTIC_VERSION) + ", markFile=" + String.valueOf(this.markFile.markFile()) + "}";
    }

    private void signalReady(int version, long activityTimestamp) {
        if (!this.markFile.isClosed()) {
            this.markFile.timestampRelease(activityTimestamp);
            this.markFile.signalReady(version);
            this.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int headerOffset(File file) {
        MappedByteBuffer mappedByteBuffer = IoUtil.mapExistingFile((File)file, (String)FILENAME);
        try {
            UnsafeBuffer unsafeBuffer = new UnsafeBuffer((ByteBuffer)mappedByteBuffer, 0, 8);
            int n = ClusterMarkFile.headerOffset(unsafeBuffer);
            return n;
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)mappedByteBuffer);
        }
    }

    private static int headerOffset(UnsafeBuffer headerBuffer) {
        MessageHeaderDecoder decoder = new MessageHeaderDecoder();
        decoder.wrap((DirectBuffer)headerBuffer, 0);
        return 200 == decoder.templateId() && 110 == decoder.schemaId() ? 8 : 0;
    }

    private static MarkFile openExistingMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, Consumer<String> logger) {
        int headerOffset = ClusterMarkFile.headerOffset(new File(directory, filename));
        return new MarkFile(directory, filename, headerOffset + MarkFileHeaderDecoder.versionEncodingOffset(), headerOffset + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), timeoutMs, epochClock, version -> {
            if (SemanticVersion.major((int)version) != 0) {
                throw new ClusterException("mark file major version " + SemanticVersion.major((int)version) + " does not match software: 0");
            }
        }, logger);
    }
}

