/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.CommandProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PendingSetupMessageFromSource;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public final class Receiver
implements Agent {
    private static final PublicationImage[] EMPTY_IMAGES = new PublicationImage[0];
    private final long reResolutionCheckIntervalNs;
    private long reResolutionDeadlineNs;
    private final DataTransportPoller dataTransportPoller;
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue;
    private final AtomicCounter totalBytesReceived;
    private final AtomicCounter resolutionChanges;
    private final NanoClock nanoClock;
    private final CachedNanoClock cachedNanoClock;
    private PublicationImage[] publicationImages = EMPTY_IMAGES;
    private final ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = new ArrayList();
    private final DriverConductorProxy conductorProxy;
    private final DutyCycleTracker dutyCycleTracker;

    Receiver(MediaDriver.Context ctx) {
        this.dataTransportPoller = ctx.dataTransportPoller();
        this.commandQueue = ctx.receiverCommandQueue();
        this.totalBytesReceived = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_RECEIVED);
        this.resolutionChanges = ctx.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES);
        this.nanoClock = ctx.nanoClock();
        this.cachedNanoClock = ctx.receiverCachedNanoClock();
        this.conductorProxy = ctx.driverConductorProxy();
        this.reResolutionCheckIntervalNs = ctx.reResolutionCheckIntervalNs();
        this.dutyCycleTracker = ctx.receiverDutyCycleTracker();
    }

    public void onStart() {
        long nowNs = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        this.dutyCycleTracker.update(nowNs);
        this.reResolutionDeadlineNs = nowNs + this.reResolutionCheckIntervalNs;
        if (this.dutyCycleTracker instanceof DutyCycleStallTracker) {
            DutyCycleStallTracker dutyCycleStallTracker = (DutyCycleStallTracker)this.dutyCycleTracker;
            dutyCycleStallTracker.maxCycleTime().appendToLabel(": " + this.conductorProxy.threadingMode().name());
            dutyCycleStallTracker.cycleTimeThresholdExceededCount().appendToLabel(": threshold=" + dutyCycleStallTracker.cycleTimeThresholdNs() + "ns " + this.conductorProxy.threadingMode().name());
        }
    }

    public void onClose() {
        this.dataTransportPoller.close();
    }

    public String roleName() {
        return "receiver";
    }

    public int doWork() {
        int lastIndex;
        long nowNs = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        this.dutyCycleTracker.measureAndUpdate(nowNs);
        int workCount = this.commandQueue.drain(CommandProxy.RUN_TASK, 1);
        int bytesReceived = this.dataTransportPoller.pollTransports();
        this.totalBytesReceived.getAndAddOrdered((long)bytesReceived);
        PublicationImage[] publicationImages = this.publicationImages;
        for (int i = lastIndex = publicationImages.length - 1; i >= 0; --i) {
            PublicationImage image = publicationImages[i];
            if (image.isConnected(nowNs)) {
                image.checkEosForDrainTransition(nowNs);
                workCount += image.sendPendingStatusMessage(nowNs);
                workCount += image.processPendingLoss();
                workCount += image.initiateAnyRttMeasurements(nowNs);
                continue;
            }
            this.publicationImages = 1 == this.publicationImages.length ? EMPTY_IMAGES : (PublicationImage[])ArrayUtil.remove((Object[])this.publicationImages, (int)i);
            image.removeFromDispatcher();
            image.receiverRelease();
        }
        this.checkPendingSetupMessages(nowNs);
        if (this.reResolutionCheckIntervalNs > 0L && this.reResolutionDeadlineNs - nowNs < 0L) {
            this.reResolutionDeadlineNs = nowNs + this.reResolutionCheckIntervalNs;
            this.dataTransportPoller.checkForReResolutions(nowNs, this.conductorProxy);
        }
        return workCount + bytesReceived;
    }

    void addPendingSetupMessage(int sessionId, int streamId, int transportIndex, ReceiveChannelEndpoint channelEndpoint, boolean periodic, InetSocketAddress controlAddress) {
        PendingSetupMessageFromSource cmd = new PendingSetupMessageFromSource(sessionId, streamId, transportIndex, channelEndpoint, periodic, controlAddress);
        cmd.timeOfStatusMessageNs(this.cachedNanoClock.nanoTime());
        this.pendingSetupMessages.add(cmd);
    }

    void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.dispatcher().addSubscription(streamId);
    }

    void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        channelEndpoint.dispatcher().addSubscription(streamId, sessionId);
        if (channelEndpoint.hasExplicitControl()) {
            channelEndpoint.sendSetupElicitingStatusMessage(0, channelEndpoint.explicitControlAddress(), sessionId, streamId);
        }
    }

    void onRequestSetup(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        if (channelEndpoint.hasExplicitControl()) {
            channelEndpoint.sendSetupElicitingStatusMessage(0, channelEndpoint.explicitControlAddress(), sessionId, streamId);
        }
    }

    void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.dispatcher().removeSubscription(streamId);
    }

    void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        int lastIndex;
        channelEndpoint.dispatcher().removeSubscription(streamId, sessionId);
        ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = this.pendingSetupMessages;
        for (int i = lastIndex = pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource pending = pendingSetupMessages.get(i);
            if (pending.channelEndpoint() != channelEndpoint || pending.streamId() != streamId || pending.sessionId() != sessionId) continue;
            ArrayListUtil.fastUnorderedRemove(pendingSetupMessages, (int)i, (int)lastIndex--);
            pending.removeFromDataPacketDispatcher();
        }
    }

    void onNewPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        this.disconnectInactiveImage(channelEndpoint, image.streamId(), image.sessionId());
        this.publicationImages = (PublicationImage[])ArrayUtil.add((Object[])this.publicationImages, (Object)image);
        channelEndpoint.dispatcher().addPublicationImage(image);
    }

    void onRegisterReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (!channelEndpoint.hasDestinationControl()) {
            channelEndpoint.registerForRead(this.dataTransportPoller);
            if (channelEndpoint.hasExplicitControl()) {
                this.addPendingSetupMessage(0, 0, 0, channelEndpoint, true, channelEndpoint.explicitControlAddress());
                channelEndpoint.sendSetupElicitingStatusMessage(0, channelEndpoint.explicitControlAddress(), 0, 0);
            }
        }
    }

    void onCloseReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        int lastIndex;
        ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = this.pendingSetupMessages;
        for (int i = lastIndex = pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource pending = pendingSetupMessages.get(i);
            if (pending.channelEndpoint() != channelEndpoint) continue;
            ArrayListUtil.fastUnorderedRemove(pendingSetupMessages, (int)i, (int)lastIndex--);
            pending.removeFromDataPacketDispatcher();
        }
        channelEndpoint.closeMultiRcvDestinationTransports(this.dataTransportPoller);
        channelEndpoint.close();
        channelEndpoint.closeMultiRcvDestinationIndicators(this.conductorProxy);
    }

    void onRemoveCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        channelEndpoint.dispatcher().removeCoolDown(sessionId, streamId);
    }

    void onAddDestination(ReceiveChannelEndpoint channelEndpoint, ReceiveDestinationTransport transport) {
        int transportIndex = channelEndpoint.addDestination(transport);
        SelectionKey key = this.dataTransportPoller.registerForRead(channelEndpoint, transport, transportIndex);
        transport.selectionKey(key);
        if (transport.hasExplicitControl()) {
            this.addPendingSetupMessage(0, 0, transportIndex, channelEndpoint, true, transport.explicitControlAddress());
            channelEndpoint.sendSetupElicitingStatusMessage(transportIndex, transport.explicitControlAddress(), 0, 0);
        }
        for (PublicationImage image : this.publicationImages) {
            if (channelEndpoint != image.channelEndpoint()) continue;
            image.addDestination(transportIndex, transport);
        }
    }

    void onRemoveDestination(ReceiveChannelEndpoint channelEndpoint, UdpChannel udpChannel) {
        int transportIndex = channelEndpoint.destination(udpChannel);
        if (-1 != transportIndex) {
            ReceiveDestinationTransport transport = channelEndpoint.destination(transportIndex);
            this.dataTransportPoller.cancelRead(channelEndpoint, transport);
            channelEndpoint.removeDestination(transportIndex);
            transport.closeTransport();
            this.dataTransportPoller.selectNowWithoutProcessing();
            for (PublicationImage image : this.publicationImages) {
                if (channelEndpoint != image.channelEndpoint()) continue;
                image.removeDestination(transportIndex);
            }
            this.conductorProxy.closeReceiveDestinationIndicators(transport);
        }
    }

    void onResolutionChange(ReceiveChannelEndpoint channelEndpoint, UdpChannel channel, InetSocketAddress newAddress) {
        int transportIndex = channelEndpoint.hasDestinationControl() ? channelEndpoint.destination(channel) : 0;
        int size = this.pendingSetupMessages.size();
        for (int i = 0; i < size; ++i) {
            PendingSetupMessageFromSource pending = this.pendingSetupMessages.get(i);
            if (pending.channelEndpoint() != channelEndpoint || !pending.isPeriodic() || pending.transportIndex() != transportIndex) continue;
            pending.controlAddress(newAddress);
            this.resolutionChanges.getAndAddOrdered(1L);
        }
        channelEndpoint.updateControlAddress(transportIndex, newAddress);
    }

    void onRejectImage(long imageCorrelationId, long position, String reason) {
        for (PublicationImage image : this.publicationImages) {
            if (imageCorrelationId != image.correlationId()) continue;
            image.reject(reason);
            break;
        }
    }

    private void checkPendingSetupMessages(long nowNs) {
        int lastIndex;
        for (int i = lastIndex = this.pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource pending = this.pendingSetupMessages.get(i);
            if (pending.timeOfStatusMessageNs() + Configuration.PENDING_SETUPS_TIMEOUT_NS - nowNs >= 0L) continue;
            if (!pending.isPeriodic()) {
                ArrayListUtil.fastUnorderedRemove(this.pendingSetupMessages, (int)i, (int)lastIndex--);
                pending.removeFromDataPacketDispatcher();
                continue;
            }
            if (!pending.shouldElicitSetupMessage()) continue;
            pending.timeOfStatusMessageNs(nowNs);
            pending.channelEndpoint().sendSetupElicitingStatusMessage(pending.transportIndex(), pending.controlAddress(), pending.sessionId(), pending.streamId());
        }
    }

    void disconnectInactiveImage(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        for (PublicationImage publicationImage : this.publicationImages) {
            if (publicationImage.channelEndpoint() != channelEndpoint || publicationImage.streamId() != streamId || publicationImage.sessionId() != sessionId) continue;
            publicationImage.stopStatusMessagesIfNotActive();
        }
    }
}

