/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.wrapper;

import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.wrapper.CallableStatementWrapper;
import io.agroal.pool.wrapper.PreparedStatementWrapper;
import io.agroal.pool.wrapper.StatementWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

public final class ConnectionWrapper
implements Connection {
    private static final InvocationHandler CLOSED_HANDLER = (proxy, method, args) -> {
        switch (method.getName()) {
            case "abort": {
                return Void.TYPE;
            }
            case "close": {
                return Void.TYPE;
            }
            case "isClosed": {
                return Boolean.TRUE;
            }
            case "isValid": {
                return Boolean.FALSE;
            }
            case "toString": {
                return ConnectionWrapper.class.getSimpleName() + ".CLOSED_CONNECTION";
            }
        }
        throw new SQLException("Connection is closed");
    };
    private static final Connection CLOSED_CONNECTION = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, CLOSED_HANDLER);
    private static final JdbcResourcesLeakReport JDBC_RESOURCES_NOT_LEAKED = new JdbcResourcesLeakReport(0, 0);
    private final boolean detached;
    private final Collection<Statement> trackedStatements;
    private final ConnectionHandler handler;
    private Connection wrappedConnection;

    public ConnectionWrapper(ConnectionHandler connectionHandler, boolean trackResources) {
        this(connectionHandler, trackResources, false);
    }

    public ConnectionWrapper(ConnectionHandler connectionHandler, boolean trackResources, boolean detached) {
        this.handler = connectionHandler;
        this.wrappedConnection = connectionHandler.getConnection();
        this.trackedStatements = trackResources ? new ConcurrentLinkedQueue() : null;
        this.detached = detached;
    }

    public ConnectionHandler getHandler() {
        return this.handler;
    }

    public boolean isDetached() {
        return this.detached;
    }

    private Statement trackStatement(Statement statement) {
        if (this.trackedStatements != null && statement != null) {
            StatementWrapper wrappedStatement = new StatementWrapper(this, statement, true);
            this.trackedStatements.add(wrappedStatement);
            return wrappedStatement;
        }
        return statement;
    }

    private CallableStatement trackCallableStatement(CallableStatement statement) {
        if (this.trackedStatements != null && statement != null) {
            CallableStatementWrapper wrappedStatement = new CallableStatementWrapper(this, statement, true);
            this.trackedStatements.add(wrappedStatement);
            return wrappedStatement;
        }
        return statement;
    }

    private PreparedStatement trackPreparedStatement(PreparedStatement statement) {
        if (this.trackedStatements != null && statement != null) {
            PreparedStatementWrapper wrappedStatement = new PreparedStatementWrapper(this, statement, true);
            this.trackedStatements.add(wrappedStatement);
            return wrappedStatement;
        }
        return statement;
    }

    private JdbcResourcesLeakReport closeTrackedStatements() throws SQLException {
        if (this.trackedStatements != null && !this.trackedStatements.isEmpty()) {
            int statementCount = this.trackedStatements.size();
            int resultSetCount = 0;
            for (Statement statement : this.trackedStatements) {
                resultSetCount += ((StatementWrapper)statement).trackedResultSetSize();
                statement.close();
            }
            this.trackedStatements.clear();
            return new JdbcResourcesLeakReport(statementCount, resultSetCount);
        }
        return JDBC_RESOURCES_NOT_LEAKED;
    }

    public void releaseTrackedStatement(Statement statement) {
        if (this.trackedStatements != null) {
            this.trackedStatements.remove(statement);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.wrappedConnection != CLOSED_CONNECTION) {
            this.wrappedConnection = CLOSED_CONNECTION;
            this.handler.onConnectionWrapperClose(this, this.closeTrackedStatements());
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.wrappedConnection = CLOSED_CONNECTION;
            this.wrappedConnection.abort(executor);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && this.handler.isEnlisted()) {
            this.handler.setFlushOnly();
            throw new SQLException("Trying to set autocommit in connection taking part of transaction");
        }
        try {
            this.handler.deferredEnlistmentCheck();
            if (this.wrappedConnection.getAutoCommit() != autoCommit) {
                this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.AUTOCOMMIT);
                this.wrappedConnection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getAutoCommit();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.handler.isEnlisted()) {
            this.handler.setFlushOnly();
            throw new SQLException("Attempting to commit while taking part in a transaction");
        }
        try {
            this.wrappedConnection.commit();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.handler.isEnlisted()) {
            this.handler.setFlushOnly();
            throw new SQLException("Attempting to rollback while enlisted in a transaction");
        }
        try {
            this.handler.deferredEnlistmentCheck();
            this.wrappedConnection.rollback();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.handler.isEnlisted()) {
            this.handler.setFlushOnly();
            throw new SQLException("Attempting to rollback while enlisted in a transaction");
        }
        try {
            this.handler.deferredEnlistmentCheck();
            this.wrappedConnection.rollback(savepoint);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.wrappedConnection.clearWarnings();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.createClob();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.createBlob();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.createNClob();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.createSQLXML();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.createArrayOf(typeName, elements);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackStatement(this.wrappedConnection.createStatement());
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackStatement(this.wrappedConnection.createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackStatement(this.wrappedConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.createStruct(typeName, attributes);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getCatalog();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.CATALOG);
            this.wrappedConnection.setCatalog(catalog);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getHoldability();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.wrappedConnection.setHoldability(holdability);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getClientInfo();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.wrappedConnection.setClientInfo(properties);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getClientInfo(name);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getMetaData();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getNetworkTimeout();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getSchema();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.SCHEMA);
            this.wrappedConnection.setSchema(schema);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getTypeMap();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.wrappedConnection.setTypeMap(map);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getTransactionIsolation();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.TRANSACTION_ISOLATION);
            this.wrappedConnection.setTransactionIsolation(level);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.getWarnings();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.isClosed();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.isReadOnly();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.wrappedConnection.setReadOnly(readOnly);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.isValid(timeout);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.nativeSQL(sql);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackCallableStatement(this.wrappedConnection.prepareCall(sql));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackCallableStatement(this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackCallableStatement(this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, autoGeneratedKeys));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, columnIndexes));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, columnNames));
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.wrappedConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.wrappedConnection.setClientInfo(name, value);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.setSavepoint();
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            return this.wrappedConnection.setSavepoint(name);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.handler.deferredEnlistmentCheck();
            this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.NETWORK_TIMEOUT);
            this.wrappedConnection.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public <T> T unwrap(Class<T> target) throws SQLException {
        try {
            return this.wrappedConnection.unwrap(target);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> target) throws SQLException {
        try {
            return this.wrappedConnection.isWrapperFor(target);
        }
        catch (SQLException se) {
            this.handler.setFlushOnly(se);
            throw se;
        }
    }

    public String toString() {
        return "wrapped[" + this.wrappedConnection + (this.handler.isEnlisted() ? "]<<enrolled" : "]");
    }

    public static class JdbcResourcesLeakReport {
        private final int statementCount;
        private final int resultSetCount;

        public JdbcResourcesLeakReport(int statementCount, int resultSetCount) {
            this.statementCount = statementCount;
            this.resultSetCount = resultSetCount;
        }

        public int statementCount() {
            return this.statementCount;
        }

        public int resultSetCount() {
            return this.resultSetCount;
        }

        public boolean hasLeak() {
            return this.statementCount != 0 || this.resultSetCount != 0;
        }
    }
}

