/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.util.JsonUtil;

public class ModelTypeDetector {
    public static ModelType discoverModelType(ObjectNode json) {
        String asyncapi = JsonUtil.getStringProperty(json, "asyncapi");
        String openapi = JsonUtil.getStringProperty(json, "openapi");
        String swagger = JsonUtil.getStringProperty(json, "swagger");
        if (asyncapi != null) {
            if (asyncapi.startsWith("2.0")) {
                return ModelType.ASYNCAPI20;
            }
            if (asyncapi.startsWith("2.1")) {
                return ModelType.ASYNCAPI21;
            }
            if (asyncapi.startsWith("2.2")) {
                return ModelType.ASYNCAPI22;
            }
            if (asyncapi.startsWith("2.3")) {
                return ModelType.ASYNCAPI23;
            }
            if (asyncapi.startsWith("2.4")) {
                return ModelType.ASYNCAPI24;
            }
            if (asyncapi.startsWith("2.5")) {
                return ModelType.ASYNCAPI25;
            }
            if (asyncapi.startsWith("2.6")) {
                return ModelType.ASYNCAPI26;
            }
            throw new RuntimeException("Unknown/unsupported AsyncAPI version: " + asyncapi);
        }
        if (openapi != null) {
            if (openapi.startsWith("2.")) {
                return ModelType.OPENAPI20;
            }
            if (openapi.startsWith("3.0")) {
                return ModelType.OPENAPI30;
            }
            if (openapi.startsWith("3.1")) {
                return ModelType.OPENAPI31;
            }
            throw new RuntimeException("Unknown/unsupported OpenAPI version: " + openapi);
        }
        if (swagger != null) {
            if (swagger.startsWith("2.")) {
                return ModelType.OPENAPI20;
            }
            throw new RuntimeException("Unknown/unsupported OpenAPI/Swagger version: " + swagger);
        }
        throw new RuntimeException("Unknown/unsupported data model type or version.");
    }
}

