/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.models.openapi.v31.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.RootNode;
import io.apicurio.datamodels.models.ServerVariable;
import io.apicurio.datamodels.models.io.ModelWriter;
import io.apicurio.datamodels.models.openapi.OpenApiHeader;
import io.apicurio.datamodels.models.openapi.OpenApiMediaType;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Callback;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Components;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Contact;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Discriminator;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Document;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Encoding;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Example;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31ExternalDocumentation;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Header;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Info;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31License;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Link;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31MediaType;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlow;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31OAuthFlows;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Operation;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Parameter;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31PathItem;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Paths;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31RequestBody;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Response;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Responses;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityRequirement;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityScheme;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Server;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31ServerVariable;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Tag;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31XML;
import io.apicurio.datamodels.models.union.Union;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.apicurio.datamodels.models.util.WriterUtil;
import java.util.List;
import java.util.Map;

public class OpenApi31ModelWriter
implements ModelWriter {
    public void writeDocument(OpenApi31Document node, ObjectNode json) {
        Map<String, JsonNode> values;
        ArrayNode array;
        List<Node> models;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "openapi", node.getOpenapi());
        JsonUtil.setStringProperty(json, "jsonSchemaDialect", node.getJsonSchemaDialect());
        if (node.getInfo() != null) {
            object = JsonUtil.objectNode();
            this.writeInfo((OpenApi31Info)node.getInfo(), object);
            JsonUtil.setObjectProperty(json, "info", object);
        }
        if ((models = node.getServers()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeServer((OpenApi31Server)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "servers", (JsonNode)array);
        }
        if (node.getPaths() != null) {
            object = JsonUtil.objectNode();
            this.writePaths((OpenApi31Paths)node.getPaths(), object);
            JsonUtil.setObjectProperty(json, "paths", object);
        }
        if ((models = node.getWebhooks()) != null) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writePathItem((OpenApi31PathItem)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object2, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "webhooks", object2);
        }
        if (node.getComponents() != null) {
            object = JsonUtil.objectNode();
            this.writeComponents(node.getComponents(), object);
            JsonUtil.setObjectProperty(json, "components", object);
        }
        if ((models = node.getSecurity()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityRequirement((OpenApi31SecurityRequirement)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getTags()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeTag((OpenApi31Tag)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "tags", (JsonNode)array);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((OpenApi31ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    @Override
    public ObjectNode writeRoot(RootNode node) {
        ObjectNode json = JsonUtil.objectNode();
        this.writeDocument((OpenApi31Document)node, json);
        return json;
    }

    public void writeInfo(OpenApi31Info node, ObjectNode json) {
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "termsOfService", node.getTermsOfService());
        if (node.getContact() != null) {
            object = JsonUtil.objectNode();
            this.writeContact((OpenApi31Contact)node.getContact(), object);
            JsonUtil.setObjectProperty(json, "contact", object);
        }
        if (node.getLicense() != null) {
            object = JsonUtil.objectNode();
            this.writeLicense((OpenApi31License)node.getLicense(), object);
            JsonUtil.setObjectProperty(json, "license", object);
        }
        JsonUtil.setStringProperty(json, "version", node.getVersion());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeContact(OpenApi31Contact node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        JsonUtil.setStringProperty(json, "email", node.getEmail());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeLicense(OpenApi31License node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "identifier", node.getIdentifier());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServer(OpenApi31Server node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        Map<String, ServerVariable> models = node.getVariables();
        if (models != null) {
            ObjectNode object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeServerVariable((OpenApi31ServerVariable)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "variables", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeServerVariable(OpenApi31ServerVariable node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setStringProperty(json, "default", node.getDefault());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeComponents(OpenApi31Components node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        Map<String, Node> models = node.getSchemas();
        if (models != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((OpenApi31Schema)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "schemas", object);
        }
        if ((models = node.getResponses()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeResponse((OpenApi31Response)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "responses", object);
        }
        if ((models = node.getParameters()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeParameter((OpenApi31Parameter)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "parameters", object);
        }
        if ((models = node.getExamples()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeExample((OpenApi31Example)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "examples", object);
        }
        if ((models = node.getRequestBodies()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeRequestBody((OpenApi31RequestBody)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "requestBodies", object);
        }
        if ((models = node.getHeaders()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeHeader((OpenApi31Header)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "headers", object);
        }
        if ((models = node.getSecuritySchemes()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSecurityScheme((OpenApi31SecurityScheme)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "securitySchemes", object);
        }
        if ((models = node.getLinks()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeLink((OpenApi31Link)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "links", object);
        }
        if ((models = node.getCallbacks()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeCallback((OpenApi31Callback)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "callbacks", object);
        }
        if ((models = node.getPathItems()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writePathItem((OpenApi31PathItem)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "pathItems", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writePaths(OpenApi31Paths node, ObjectNode json) {
        if (node == null) {
            return;
        }
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writePathItem((OpenApi31PathItem)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writePathItem(OpenApi31PathItem node, ObjectNode json) {
        Map<String, JsonNode> values;
        ArrayNode array;
        List<Node> models;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getGet() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((OpenApi31Operation)node.getGet(), object);
            JsonUtil.setObjectProperty(json, "get", object);
        }
        if (node.getPut() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((OpenApi31Operation)node.getPut(), object);
            JsonUtil.setObjectProperty(json, "put", object);
        }
        if (node.getPost() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((OpenApi31Operation)node.getPost(), object);
            JsonUtil.setObjectProperty(json, "post", object);
        }
        if (node.getDelete() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((OpenApi31Operation)node.getDelete(), object);
            JsonUtil.setObjectProperty(json, "delete", object);
        }
        if (node.getOptions() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((OpenApi31Operation)node.getOptions(), object);
            JsonUtil.setObjectProperty(json, "options", object);
        }
        if (node.getHead() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((OpenApi31Operation)node.getHead(), object);
            JsonUtil.setObjectProperty(json, "head", object);
        }
        if (node.getPatch() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation((OpenApi31Operation)node.getPatch(), object);
            JsonUtil.setObjectProperty(json, "patch", object);
        }
        if (node.getTrace() != null) {
            object = JsonUtil.objectNode();
            this.writeOperation(node.getTrace(), object);
            JsonUtil.setObjectProperty(json, "trace", object);
        }
        if ((models = node.getServers()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeServer((OpenApi31Server)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "servers", (JsonNode)array);
        }
        if ((models = node.getParameters()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeParameter((OpenApi31Parameter)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "parameters", (JsonNode)array);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOperation(OpenApi31Operation node, ObjectNode json) {
        Map<String, JsonNode> values;
        ArrayNode array;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringArrayProperty(json, "tags", node.getTags());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((OpenApi31ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        JsonUtil.setStringProperty(json, "operationId", node.getOperationId());
        List<Node> models = node.getParameters();
        if (models != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeParameter((OpenApi31Parameter)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "parameters", (JsonNode)array);
        }
        if (node.getRequestBody() != null) {
            object = JsonUtil.objectNode();
            this.writeRequestBody(node.getRequestBody(), object);
            JsonUtil.setObjectProperty(json, "requestBody", object);
        }
        if (node.getResponses() != null) {
            object = JsonUtil.objectNode();
            this.writeResponses((OpenApi31Responses)node.getResponses(), object);
            JsonUtil.setObjectProperty(json, "responses", object);
        }
        if ((models = node.getCallbacks()) != null) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(arg_0 -> this.lambda$writeOperation$28((Map)((Object)models), object2, arg_0));
            JsonUtil.setObjectProperty(json, "callbacks", object2);
        }
        JsonUtil.setBooleanProperty(json, "deprecated", node.isDeprecated());
        models = node.getSecurity();
        if (models != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSecurityRequirement((OpenApi31SecurityRequirement)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "security", (JsonNode)array);
        }
        if ((models = node.getServers()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeServer((OpenApi31Server)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "servers", (JsonNode)array);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeExternalDocumentation(OpenApi31ExternalDocumentation node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "url", node.getUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeParameter(OpenApi31Parameter node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "in", node.getIn());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setBooleanProperty(json, "required", node.isRequired());
        JsonUtil.setBooleanProperty(json, "deprecated", node.isDeprecated());
        JsonUtil.setBooleanProperty(json, "allowEmptyValue", node.isAllowEmptyValue());
        JsonUtil.setStringProperty(json, "style", node.getStyle());
        JsonUtil.setBooleanProperty(json, "explode", node.isExplode());
        JsonUtil.setBooleanProperty(json, "allowReserved", node.isAllowReserved());
        if (node.getSchema() != null) {
            ObjectNode object2 = JsonUtil.objectNode();
            this.writeSchema((OpenApi31Schema)node.getSchema(), object2);
            JsonUtil.setObjectProperty(json, "schema", object2);
        }
        JsonUtil.setAnyProperty(json, "example", node.getExample());
        Map<String, Node> models = node.getExamples();
        if (models != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeExample((OpenApi31Example)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "examples", object);
        }
        if ((models = node.getContent()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMediaType((OpenApi31MediaType)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "content", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeRequestBody(OpenApi31RequestBody node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        Map<String, OpenApiMediaType> models = node.getContent();
        if (models != null) {
            ObjectNode object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMediaType((OpenApi31MediaType)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "content", object);
        }
        JsonUtil.setBooleanProperty(json, "required", node.isRequired());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeMediaType(OpenApi31MediaType node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getSchema() != null) {
            ObjectNode object2 = JsonUtil.objectNode();
            this.writeSchema((OpenApi31Schema)node.getSchema(), object2);
            JsonUtil.setObjectProperty(json, "schema", object2);
        }
        JsonUtil.setAnyProperty(json, "example", node.getExample());
        Map<String, Node> models = node.getExamples();
        if (models != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeExample((OpenApi31Example)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "examples", object);
        }
        if ((models = node.getEncoding()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeEncoding((OpenApi31Encoding)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "encoding", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeEncoding(OpenApi31Encoding node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "contentType", node.getContentType());
        Map<String, OpenApiHeader> models = node.getHeaders();
        if (models != null) {
            ObjectNode object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeHeader((OpenApi31Header)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "headers", object);
        }
        JsonUtil.setStringProperty(json, "style", node.getStyle());
        JsonUtil.setBooleanProperty(json, "explode", node.isExplode());
        JsonUtil.setBooleanProperty(json, "allowReserved", node.isAllowReserved());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeResponses(OpenApi31Responses node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getDefault() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeResponse((OpenApi31Response)node.getDefault(), object);
            JsonUtil.setObjectProperty(json, "default", object);
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writeResponse((OpenApi31Response)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeResponse(OpenApi31Response node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        Map<String, Node> models = node.getHeaders();
        if (models != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeHeader((OpenApi31Header)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "headers", object);
        }
        if ((models = node.getContent()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMediaType((OpenApi31MediaType)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "content", object);
        }
        if ((models = node.getLinks()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeLink((OpenApi31Link)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "links", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeCallback(OpenApi31Callback node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            ObjectNode object = JsonUtil.objectNode();
            this.writePathItem((OpenApi31PathItem)node.getItem((String)propertyName), object);
            JsonUtil.setObjectProperty(json, propertyName, object);
        });
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeExample(OpenApi31Example node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setAnyProperty(json, "value", node.getValue());
        JsonUtil.setStringProperty(json, "externalValue", node.getExternalValue());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeLink(OpenApi31Link node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "operationRef", node.getOperationRef());
        JsonUtil.setStringProperty(json, "operationId", node.getOperationId());
        JsonUtil.setAnyMapProperty(json, "parameters", node.getParameters());
        JsonUtil.setAnyProperty(json, "requestBody", node.getRequestBody());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getServer() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeServer((OpenApi31Server)node.getServer(), object);
            JsonUtil.setObjectProperty(json, "server", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeHeader(OpenApi31Header node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setBooleanProperty(json, "required", node.isRequired());
        JsonUtil.setBooleanProperty(json, "deprecated", node.isDeprecated());
        JsonUtil.setBooleanProperty(json, "allowEmptyValue", node.isAllowEmptyValue());
        JsonUtil.setStringProperty(json, "style", node.getStyle());
        JsonUtil.setBooleanProperty(json, "explode", node.isExplode());
        JsonUtil.setBooleanProperty(json, "allowReserved", node.isAllowReserved());
        if (node.getSchema() != null) {
            ObjectNode object2 = JsonUtil.objectNode();
            this.writeSchema(node.getSchema(), object2);
            JsonUtil.setObjectProperty(json, "schema", object2);
        }
        JsonUtil.setAnyProperty(json, "example", node.getExample());
        Map<String, Node> models = node.getExamples();
        if (models != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeExample((OpenApi31Example)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "examples", object);
        }
        if ((models = node.getContent()) != null) {
            object = JsonUtil.objectNode();
            models.keySet().forEach(jsonName -> {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeMediaType((OpenApi31MediaType)models.get(jsonName), jsonValue);
                JsonUtil.setObjectProperty(object, jsonName, jsonValue);
            });
            JsonUtil.setObjectProperty(json, "content", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeTag(OpenApi31Tag node, ObjectNode json) {
        Map<String, JsonNode> values;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        if (node.getExternalDocs() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeExternalDocumentation((OpenApi31ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSchema(OpenApi31Schema node, ObjectNode json) {
        ArrayNode array;
        List<OpenApi31Schema> models;
        ObjectNode object;
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "format", node.getFormat());
        JsonUtil.setStringProperty(json, "title", node.getTitle());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setAnyProperty(json, "default", node.getDefault());
        JsonUtil.setNumberProperty(json, "multipleOf", node.getMultipleOf());
        JsonUtil.setNumberProperty(json, "maximum", node.getMaximum());
        JsonUtil.setNumberProperty(json, "exclusiveMaximum", node.getExclusiveMaximum());
        JsonUtil.setNumberProperty(json, "minimum", node.getMinimum());
        JsonUtil.setNumberProperty(json, "exclusiveMinimum", node.getExclusiveMinimum());
        JsonUtil.setIntegerProperty(json, "maxLength", node.getMaxLength());
        JsonUtil.setIntegerProperty(json, "minLength", node.getMinLength());
        JsonUtil.setStringProperty(json, "pattern", node.getPattern());
        JsonUtil.setIntegerProperty(json, "maxItems", node.getMaxItems());
        JsonUtil.setIntegerProperty(json, "minItems", node.getMinItems());
        JsonUtil.setBooleanProperty(json, "uniqueItems", node.isUniqueItems());
        JsonUtil.setIntegerProperty(json, "maxProperties", node.getMaxProperties());
        JsonUtil.setIntegerProperty(json, "minProperties", node.getMinProperties());
        JsonUtil.setStringArrayProperty(json, "required", node.getRequired());
        JsonUtil.setAnyArrayProperty(json, "enum", node.getEnum());
        JsonUtil.setAnyProperty(json, "const", node.getConst());
        Union union = node.getType();
        if (union != null) {
            if (union.isString()) {
                JsonUtil.setStringProperty(json, "type", union.asString());
            }
            if (union.isStringList()) {
                JsonUtil.setStringArrayProperty(json, "type", union.asStringList());
            }
        }
        if (node.getItems() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema(node.getItems(), object);
            JsonUtil.setObjectProperty(json, "items", object);
        }
        if ((models = node.getAllOf()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((OpenApi31Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "allOf", (JsonNode)array);
        }
        if ((models = node.getProperties()) != null) {
            ObjectNode object2 = JsonUtil.objectNode();
            models.keySet().forEach(arg_0 -> this.lambda$writeSchema$58((Map)((Object)models), object2, arg_0));
            JsonUtil.setObjectProperty(json, "properties", object2);
        }
        if ((union = node.getAdditionalProperties()) != null) {
            if (union.isBoolean()) {
                JsonUtil.setBooleanProperty(json, "additionalProperties", union.asBoolean());
            }
            if (union.isSchema()) {
                ObjectNode jsonValue = JsonUtil.objectNode();
                this.writeSchema((OpenApi31Schema)union.asSchema(), jsonValue);
                JsonUtil.setObjectProperty(json, "additionalProperties", jsonValue);
            }
        }
        JsonUtil.setBooleanProperty(json, "readOnly", node.isReadOnly());
        if (node.getXml() != null) {
            object = JsonUtil.objectNode();
            this.writeXML((OpenApi31XML)node.getXml(), object);
            JsonUtil.setObjectProperty(json, "xml", object);
        }
        if (node.getExternalDocs() != null) {
            object = JsonUtil.objectNode();
            this.writeExternalDocumentation((OpenApi31ExternalDocumentation)node.getExternalDocs(), object);
            JsonUtil.setObjectProperty(json, "externalDocs", object);
        }
        JsonUtil.setAnyProperty(json, "example", node.getExample());
        models = node.getOneOf();
        if (models != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((OpenApi31Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "oneOf", (JsonNode)array);
        }
        if ((models = node.getAnyOf()) != null) {
            array = JsonUtil.arrayNode();
            models.forEach(model -> {
                ObjectNode object = JsonUtil.objectNode();
                this.writeSchema((OpenApi31Schema)model, object);
                JsonUtil.addToArray(array, (JsonNode)object);
            });
            JsonUtil.setAnyProperty(json, "anyOf", (JsonNode)array);
        }
        if (node.getNot() != null) {
            object = JsonUtil.objectNode();
            this.writeSchema(node.getNot(), object);
            JsonUtil.setObjectProperty(json, "not", object);
        }
        if (node.getDiscriminator() != null) {
            object = JsonUtil.objectNode();
            this.writeDiscriminator(node.getDiscriminator(), object);
            JsonUtil.setObjectProperty(json, "discriminator", object);
        }
        JsonUtil.setBooleanProperty(json, "writeOnly", node.isWriteOnly());
        JsonUtil.setBooleanProperty(json, "deprecated", node.isDeprecated());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeDiscriminator(OpenApi31Discriminator node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "propertyName", node.getPropertyName());
        JsonUtil.setStringMapProperty(json, "mapping", node.getMapping());
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeXML(OpenApi31XML node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "namespace", node.getNamespace());
        JsonUtil.setStringProperty(json, "prefix", node.getPrefix());
        JsonUtil.setBooleanProperty(json, "attribute", node.isAttribute());
        JsonUtil.setBooleanProperty(json, "wrapped", node.isWrapped());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSecurityScheme(OpenApi31SecurityScheme node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "$ref", node.get$ref());
        JsonUtil.setStringProperty(json, "summary", node.getSummary());
        JsonUtil.setStringProperty(json, "type", node.getType());
        JsonUtil.setStringProperty(json, "description", node.getDescription());
        JsonUtil.setStringProperty(json, "name", node.getName());
        JsonUtil.setStringProperty(json, "in", node.getIn());
        JsonUtil.setStringProperty(json, "scheme", node.getScheme());
        JsonUtil.setStringProperty(json, "bearerFormat", node.getBearerFormat());
        if (node.getFlows() != null) {
            ObjectNode object = JsonUtil.objectNode();
            this.writeOAuthFlows(node.getFlows(), object);
            JsonUtil.setObjectProperty(json, "flows", object);
        }
        JsonUtil.setStringProperty(json, "openIdConnectUrl", node.getOpenIdConnectUrl());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlows(OpenApi31OAuthFlows node, ObjectNode json) {
        Map<String, JsonNode> values;
        ObjectNode object;
        if (node == null) {
            return;
        }
        if (node.getImplicit() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((OpenApi31OAuthFlow)node.getImplicit(), object);
            JsonUtil.setObjectProperty(json, "implicit", object);
        }
        if (node.getPassword() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((OpenApi31OAuthFlow)node.getPassword(), object);
            JsonUtil.setObjectProperty(json, "password", object);
        }
        if (node.getClientCredentials() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((OpenApi31OAuthFlow)node.getClientCredentials(), object);
            JsonUtil.setObjectProperty(json, "clientCredentials", object);
        }
        if (node.getAuthorizationCode() != null) {
            object = JsonUtil.objectNode();
            this.writeOAuthFlow((OpenApi31OAuthFlow)node.getAuthorizationCode(), object);
            JsonUtil.setObjectProperty(json, "authorizationCode", object);
        }
        if ((values = node.getExtensions()) != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeOAuthFlow(OpenApi31OAuthFlow node, ObjectNode json) {
        if (node == null) {
            return;
        }
        JsonUtil.setStringProperty(json, "authorizationUrl", node.getAuthorizationUrl());
        JsonUtil.setStringProperty(json, "tokenUrl", node.getTokenUrl());
        JsonUtil.setStringProperty(json, "refreshUrl", node.getRefreshUrl());
        JsonUtil.setStringMapProperty(json, "scopes", node.getScopes());
        Map<String, JsonNode> values = node.getExtensions();
        if (values != null) {
            values.keySet().forEach(propertyName -> {
                JsonNode value = (JsonNode)values.get(propertyName);
                JsonUtil.setAnyProperty(json, propertyName, value);
            });
        }
        WriterUtil.writeExtraProperties(node, json);
    }

    public void writeSecurityRequirement(OpenApi31SecurityRequirement node, ObjectNode json) {
        if (node == null) {
            return;
        }
        List<String> propertyNames = node.getItemNames();
        propertyNames.forEach(propertyName -> {
            List value = (List)node.getItem((String)propertyName);
            JsonUtil.setStringArrayProperty(json, propertyName, value);
        });
        WriterUtil.writeExtraProperties(node, json);
    }

    private /* synthetic */ void lambda$writeSchema$58(Map models, ObjectNode object, String jsonName) {
        ObjectNode jsonValue = JsonUtil.objectNode();
        this.writeSchema((OpenApi31Schema)models.get(jsonName), jsonValue);
        JsonUtil.setObjectProperty(object, jsonName, jsonValue);
    }

    private /* synthetic */ void lambda$writeOperation$28(Map models, ObjectNode object, String jsonName) {
        ObjectNode jsonValue = JsonUtil.objectNode();
        this.writeCallback((OpenApi31Callback)models.get(jsonName), jsonValue);
        JsonUtil.setObjectProperty(object, jsonName, jsonValue);
    }
}

