/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation;

import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.visitors.TraversalContext;
import io.apicurio.datamodels.models.visitors.TraversingVisitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import io.apicurio.datamodels.validation.IValidationProblemReporter;
import io.apicurio.datamodels.validation.IValidationSeverityRegistry;
import io.apicurio.datamodels.validation.ValidationProblem;
import io.apicurio.datamodels.validation.ValidationProblemSeverity;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.ValidationRuleSet;
import io.apicurio.datamodels.visitors.CompositeAllNodeVisitor;
import java.util.ArrayList;
import java.util.List;

public class ValidationVisitor
extends CompositeAllNodeVisitor
implements IValidationProblemReporter,
TraversingVisitor {
    private List<ValidationProblem> problems = new ArrayList<ValidationProblem>();
    private IValidationSeverityRegistry severityRegistry;

    public ValidationVisitor(ModelType type) {
        super(new ArrayList<Visitor>());
        ValidationRuleSet ruleSet = ValidationRuleSet.instance;
        List<ValidationRule> rulesFor = ruleSet.getRulesFor(type);
        rulesFor.forEach(rule -> rule.setReporter(this));
        this.addVisitors(rulesFor);
    }

    @Override
    public void setTraversalContext(TraversalContext context) {
        this.getVisitors().forEach(visitor -> {
            if (visitor instanceof TraversingVisitor) {
                ((TraversingVisitor)((Object)visitor)).setTraversalContext(context);
            }
        });
    }

    public void setSeverityRegistry(IValidationSeverityRegistry severityRegistry) {
        this.severityRegistry = severityRegistry;
    }

    public List<ValidationProblem> getValidationProblems() {
        return this.problems;
    }

    @Override
    public void report(ValidationRuleMetaData ruleInfo, Node node, String property, String message) {
        ValidationProblemSeverity severity = this.severityRegistry.lookupSeverity(ruleInfo);
        if (severity == ValidationProblemSeverity.ignore) {
            return;
        }
        NodePath path = NodePathUtil.createNodePath(node);
        ValidationProblem problem = new ValidationProblem(ruleInfo.code, path, property, message, severity);
        this.problems.add(problem);
    }
}

