/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.type;

import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.util.NodeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.type.OasInvalidPropertyTypeValidationRule;
import java.util.List;

public class OasInvalidSchemaArrayItemsRule
extends OasInvalidPropertyTypeValidationRule {
    public OasInvalidSchemaArrayItemsRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitSchema(Schema node) {
        Schema items = (Schema)NodeUtil.getNodeProperty(node, "items");
        if (this.isDefined(items)) {
            OasInvalidSchemaArrayItemsRule.getTypes(node, (types, allowedTypes) -> {
                List<String> allowedItemTypes = List.of("array", "null");
                for (String type : types) {
                    if (allowedItemTypes.contains(type)) continue;
                    this.report(node, "items", this.map(new String[0]));
                    break;
                }
            });
        }
    }
}

