/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.refs.ReferenceUtil;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractInvalidPropertyValueRule
extends ValidationRule {
    public AbstractInvalidPropertyValueRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    protected boolean isValidMultipartType(String typeName) {
        return this.equals(typeName, "application/x-www-form-urlencoded") || typeName.indexOf("multipart") == 0;
    }

    protected List<OpenApiParameter> mergeParameters(OpenApiOperation node) {
        String key;
        OpenApiParameter resolutionResult;
        HashMap<CallSite, OpenApiParameter> indexedParams = new HashMap<CallSite, OpenApiParameter>();
        OpenApiPathItem parentNode = (OpenApiPathItem)node.parent();
        if (this.hasValue(parentNode.getParameters())) {
            for (OpenApiParameter param : parentNode.getParameters()) {
                resolutionResult = (OpenApiParameter)ReferenceUtil.resolveNodeRef(param);
                if (!this.hasValue(resolutionResult)) continue;
                key = resolutionResult.getIn() + "-" + resolutionResult.getName();
                indexedParams.put((CallSite)((Object)key), resolutionResult);
            }
        }
        if (this.hasValue(node.getParameters())) {
            for (OpenApiParameter param : node.getParameters()) {
                resolutionResult = (OpenApiParameter)ReferenceUtil.resolveNodeRef(param);
                if (!this.hasValue(resolutionResult)) continue;
                key = resolutionResult.getIn() + "-" + resolutionResult.getName();
                indexedParams.put((CallSite)((Object)key), resolutionResult);
            }
        }
        ArrayList<OpenApiParameter> mergedParameters = new ArrayList<OpenApiParameter>();
        mergedParameters.addAll(indexedParams.values());
        return mergedParameters;
    }
}

