/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.value;

import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.VisitorUtil;
import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.openapi.OpenApiParameter;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.invalid.value.AbstractInvalidPropertyValueRule;
import io.apicurio.datamodels.visitors.ConsumesProducesFinder;
import java.util.ArrayList;
import java.util.List;

public class OasFormDataParamNotAllowedRule
extends AbstractInvalidPropertyValueRule {
    public OasFormDataParamNotAllowedRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitParameter(Parameter node) {
        OpenApiParameter param = (OpenApiParameter)node;
        if (this.equals(param.getIn(), "formData")) {
            ConsumesProducesFinder finder = new ConsumesProducesFinder();
            VisitorUtil.visitTree(node, finder, TraverserDirection.up);
            List<String> consumes = finder.consumes;
            if (!this.hasValue(consumes)) {
                consumes = new ArrayList<String>();
            }
            boolean valid = consumes.indexOf("application/x-www-form-urlencoded") >= 0 || consumes.indexOf("multipart/form-data") >= 0;
            this.reportIfInvalid(valid, node, "consumes", this.map(new String[0]));
        }
    }
}

