/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.required;

import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.rules.required.RequiredPropertyValidationRule;

public class OasMissingOpenApiPropertyRule
extends RequiredPropertyValidationRule {
    public OasMissingOpenApiPropertyRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitDocument(Document node) {
        ModelType mt = node.root().modelType();
        if (mt == ModelType.OPENAPI20) {
            this.requireProperty(node, "swagger", this.map(new String[0]));
        } else if (mt == ModelType.OPENAPI30 || mt == ModelType.OPENAPI31) {
            this.requireProperty(node, "openapi", this.map(new String[0]));
        } else if (ModelTypeUtil.isAsyncApiModel(node)) {
            this.requireProperty(node, "asyncapi", this.map(new String[0]));
        }
    }
}

