/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.Comment;
import io.apicurio.registry.rest.v2.beans.CreateGroupMetaData;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.GroupMetaData;
import io.apicurio.registry.rest.v2.beans.GroupSearchResults;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.NewComment;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.types.ReferenceType;
import io.apicurio.registry.types.RuleType;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;

@Path(value="/apis/registry/v2/groups")
public interface GroupsResource {
    @GET
    @Produces(value={"application/json"})
    public GroupSearchResults listGroups(@QueryParam(value="limit") BigInteger var1, @QueryParam(value="offset") BigInteger var2, @QueryParam(value="order") SortOrder var3, @QueryParam(value="orderby") SortBy var4);

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public GroupMetaData createGroup(@NotNull CreateGroupMetaData var1);

    @Path(value="/{groupId}")
    @GET
    @Produces(value={"application/json"})
    public GroupMetaData getGroupById(@PathParam(value="groupId") String var1);

    @Path(value="/{groupId}")
    @DELETE
    public void deleteGroupById(@PathParam(value="groupId") String var1);

    @Path(value="/{groupId}/artifacts")
    @GET
    @Produces(value={"application/json"})
    public ArtifactSearchResults listArtifactsInGroup(@PathParam(value="groupId") String var1, @QueryParam(value="limit") BigInteger var2, @QueryParam(value="offset") BigInteger var3, @QueryParam(value="order") SortOrder var4, @QueryParam(value="orderby") SortBy var5);

    @Path(value="/{groupId}/artifacts")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public ArtifactMetaData createArtifact(@PathParam(value="groupId") String var1, @HeaderParam(value="X-Registry-ArtifactType") String var2, @HeaderParam(value="X-Registry-ArtifactId") String var3, @HeaderParam(value="X-Registry-Version") String var4, @QueryParam(value="ifExists") IfExists var5, @QueryParam(value="canonical") Boolean var6, @HeaderParam(value="X-Registry-Description") String var7, @HeaderParam(value="X-Registry-Description-Encoded") String var8, @HeaderParam(value="X-Registry-Name") String var9, @HeaderParam(value="X-Registry-Name-Encoded") String var10, @HeaderParam(value="X-Registry-Content-Hash") String var11, @HeaderParam(value="X-Registry-Hash-Algorithm") String var12, @NotNull InputStream var13);

    @Path(value="/{groupId}/artifacts")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/vnd.create.extended+json", "application/create.extended+json"})
    public ArtifactMetaData createArtifact(@PathParam(value="groupId") String var1, @HeaderParam(value="X-Registry-ArtifactType") String var2, @HeaderParam(value="X-Registry-ArtifactId") String var3, @HeaderParam(value="X-Registry-Version") String var4, @QueryParam(value="ifExists") IfExists var5, @QueryParam(value="canonical") Boolean var6, @HeaderParam(value="X-Registry-Description") String var7, @HeaderParam(value="X-Registry-Description-Encoded") String var8, @HeaderParam(value="X-Registry-Name") String var9, @HeaderParam(value="X-Registry-Name-Encoded") String var10, @HeaderParam(value="X-Registry-Content-Hash") String var11, @HeaderParam(value="X-Registry-Hash-Algorithm") String var12, @NotNull ArtifactContent var13);

    @Path(value="/{groupId}/artifacts")
    @DELETE
    public void deleteArtifactsInGroup(@PathParam(value="groupId") String var1);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @GET
    @Produces(value={"*/*"})
    public Response getLatestArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @QueryParam(value="dereference") Boolean var3);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public ArtifactMetaData updateArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @HeaderParam(value="X-Registry-Version") String var3, @HeaderParam(value="X-Registry-Name") String var4, @HeaderParam(value="X-Registry-Name-Encoded") String var5, @HeaderParam(value="X-Registry-Description") String var6, @HeaderParam(value="X-Registry-Description-Encoded") String var7, @NotNull InputStream var8);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/vnd.create.extended+json", "application/create.extended+json"})
    public ArtifactMetaData updateArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @HeaderParam(value="X-Registry-Version") String var3, @HeaderParam(value="X-Registry-Name") String var4, @HeaderParam(value="X-Registry-Name-Encoded") String var5, @HeaderParam(value="X-Registry-Description") String var6, @HeaderParam(value="X-Registry-Description-Encoded") String var7, @NotNull ArtifactContent var8);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @DELETE
    public void deleteArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/meta")
    @GET
    @Produces(value={"application/json"})
    public ArtifactMetaData getArtifactMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @NotNull EditableMetaData var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/meta")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public VersionMetaData getArtifactVersionMetaDataByContent(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @QueryParam(value="canonical") Boolean var3, @NotNull InputStream var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/meta")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/vnd.get.extended+json", "application/get.extended+json"})
    public VersionMetaData getArtifactVersionMetaDataByContent(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @QueryParam(value="canonical") Boolean var3, @NotNull ArtifactContent var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/owner")
    @GET
    @Produces(value={"application/json"})
    public ArtifactOwner getArtifactOwner(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/owner")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactOwner(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @NotNull ArtifactOwner var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listArtifactRules(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createArtifactRule(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @NotNull Rule var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @DELETE
    public void deleteArtifactRules(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{rule}")
    @GET
    @Produces(value={"application/json"})
    public Rule getArtifactRuleConfig(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="rule") RuleType var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{rule}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateArtifactRuleConfig(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="rule") RuleType var3, @NotNull Rule var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{rule}")
    @DELETE
    public void deleteArtifactRule(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="rule") RuleType var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactState(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @NotNull UpdateState var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/test")
    @PUT
    @Consumes(value={"*/*"})
    public void testUpdateArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @NotNull InputStream var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions")
    @GET
    @Produces(value={"application/json"})
    public VersionSearchResults listArtifactVersions(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @QueryParam(value="offset") BigInteger var3, @QueryParam(value="limit") BigInteger var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public VersionMetaData createArtifactVersion(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @HeaderParam(value="X-Registry-Version") String var3, @HeaderParam(value="X-Registry-Name") String var4, @HeaderParam(value="X-Registry-Description") String var5, @HeaderParam(value="X-Registry-Description-Encoded") String var6, @HeaderParam(value="X-Registry-Name-Encoded") String var7, @NotNull InputStream var8);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/vnd.create.extended+json", "application/create.extended+json"})
    public VersionMetaData createArtifactVersion(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @HeaderParam(value="X-Registry-Version") String var3, @HeaderParam(value="X-Registry-Name") String var4, @HeaderParam(value="X-Registry-Description") String var5, @HeaderParam(value="X-Registry-Description-Encoded") String var6, @HeaderParam(value="X-Registry-Name-Encoded") String var7, @NotNull ArtifactContent var8);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}")
    @GET
    @Produces(value={"*/*"})
    public Response getArtifactVersion(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, @QueryParam(value="dereference") Boolean var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}")
    @DELETE
    public void deleteArtifactVersion(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/comments")
    @GET
    @Produces(value={"application/json"})
    public List<Comment> getArtifactVersionComments(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/comments")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Comment addArtifactVersionComment(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, @NotNull NewComment var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/comments/{commentId}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionComment(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, @PathParam(value="commentId") String var4, @NotNull NewComment var5);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/comments/{commentId}")
    @DELETE
    public void deleteArtifactVersionComment(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, @PathParam(value="commentId") String var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/meta")
    @GET
    @Produces(value={"application/json"})
    public VersionMetaData getArtifactVersionMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, @NotNull EditableMetaData var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/meta")
    @DELETE
    public void deleteArtifactVersionMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/references")
    @GET
    @Produces(value={"application/json"})
    public List<ArtifactReference> getArtifactVersionReferences(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, @QueryParam(value="refType") ReferenceType var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionState(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, @NotNull UpdateState var4);
}

