/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.maven.ExistingReference;
import io.apicurio.registry.maven.RegisterArtifactReference;
import io.apicurio.registry.rest.v3.beans.IfArtifactExists;
import java.io.File;
import java.util.List;

public class RegisterArtifact {
    private String groupId;
    private String artifactId;
    private String version;
    private String artifactType;
    private File file;
    private IfArtifactExists ifExists;
    private Boolean canonicalize;
    private Boolean minify;
    private Boolean autoRefs;
    private AvroAutoRefsNamingStrategy avroAutoRefsNamingStrategy;
    private Boolean isDraft;
    private String contentType;
    private List<RegisterArtifactReference> references;
    private List<ExistingReference> existingReferences;
    private List<File> protoPaths;

    public List<File> getProtoPaths() {
        return this.protoPaths;
    }

    public void setProtoPaths(List<File> protoPaths) {
        this.protoPaths = protoPaths;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public IfArtifactExists getIfExists() {
        return this.ifExists;
    }

    public void setIfExists(IfArtifactExists ifExists) {
        this.ifExists = ifExists;
    }

    public Boolean getCanonicalize() {
        return this.canonicalize;
    }

    public void setCanonicalize(Boolean canonicalize) {
        this.canonicalize = canonicalize;
    }

    public Boolean getMinify() {
        return this.minify;
    }

    public void setMinify(Boolean minify) {
        this.minify = minify;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public List<RegisterArtifactReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<RegisterArtifactReference> references) {
        this.references = references;
    }

    public Boolean getAutoRefs() {
        return this.autoRefs;
    }

    public void setAutoRefs(Boolean autoRefs) {
        this.autoRefs = autoRefs;
    }

    public AvroAutoRefsNamingStrategy getAvroAutoRefsNamingStrategy() {
        if (Boolean.TRUE.equals(this.autoRefs) && this.avroAutoRefsNamingStrategy == null) {
            if ("AVRO".equals(this.artifactType)) {
                return AvroAutoRefsNamingStrategy.USE_AVRO_NAMESPACE;
            }
            if ("ASYNCAPI".equals(this.artifactType)) {
                return AvroAutoRefsNamingStrategy.INHERIT_PARENT_GROUP;
            }
            return AvroAutoRefsNamingStrategy.INHERIT_PARENT_GROUP;
        }
        return this.avroAutoRefsNamingStrategy;
    }

    public void setAvroAutoRefsNamingStrategy(AvroAutoRefsNamingStrategy avroAutoRefsNamingStrategy) {
        this.avroAutoRefsNamingStrategy = avroAutoRefsNamingStrategy;
    }

    public Boolean getIsDraft() {
        return this.isDraft;
    }

    public void setIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
    }

    public List<ExistingReference> getExistingReferences() {
        return this.existingReferences;
    }

    public void setExistingReferences(List<ExistingReference> existingReferences) {
        this.existingReferences = existingReferences;
    }

    public static enum AvroAutoRefsNamingStrategy {
        INHERIT_PARENT_GROUP,
        USE_AVRO_NAMESPACE;

    }
}

