/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.microsoft.kiota.ApiException;
import io.apicurio.registry.client.RegistryClientFactory;
import io.apicurio.registry.client.RegistryClientOptions;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.ProblemDetails;
import io.apicurio.registry.rest.client.models.RuleViolationProblemDetails;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.FileSystemOptions;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractRegistryMojo
extends AbstractMojo {
    @Parameter(required=true, property="apicurio.url")
    String registryUrl;
    @Parameter(property="auth.server.url")
    String authServerUrl;
    @Parameter(property="client.id")
    String clientId;
    @Parameter(property="client.secret")
    String clientSecret;
    @Parameter(property="client.scope")
    String clientScope;
    @Parameter(property="username")
    String username;
    @Parameter(property="password")
    String password;

    protected Vertx createVertx() {
        VertxOptions options = new VertxOptions();
        FileSystemOptions fsOpts = new FileSystemOptions();
        fsOpts.setFileCachingEnabled(false);
        fsOpts.setClassPathResolvingEnabled(false);
        options.setFileSystemOptions(fsOpts);
        return Vertx.vertx((VertxOptions)options);
    }

    protected RegistryClient createClient(Vertx vertx) {
        RegistryClientOptions clientOptions = RegistryClientOptions.create((String)this.registryUrl, (Vertx)vertx);
        if (this.authServerUrl != null && this.clientId != null && this.clientSecret != null) {
            if (this.clientScope != null && !this.clientScope.isEmpty()) {
                this.getLog().info((CharSequence)"Creating registry client with OAuth2 authentication with scope.");
                clientOptions.oauth2(this.authServerUrl, this.clientId, this.clientSecret, this.clientScope);
            } else {
                this.getLog().info((CharSequence)"Creating registry client with OAuth2 authentication.");
                clientOptions.oauth2(this.authServerUrl, this.clientId, this.clientSecret);
            }
        } else if (this.username != null && this.password != null) {
            this.getLog().info((CharSequence)"Creating registry client with Basic authentication.");
            clientOptions.basicAuth(this.username, this.password);
        } else {
            this.getLog().info((CharSequence)"Creating registry client without authentication.");
        }
        return RegistryClientFactory.create((RegistryClientOptions)clientOptions.retry());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.executeInternal();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new MojoFailureException((Throwable)e);
        }
        this.closeClients();
    }

    private void closeClients() {
    }

    protected abstract void executeInternal() throws MojoExecutionException, MojoFailureException, ExecutionException, InterruptedException;

    protected String getContentTypeByExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String[] temp = fileName.split("[.]");
        String extension = temp[temp.length - 1];
        switch (extension.toLowerCase(Locale.ROOT)) {
            case "avro": 
            case "avsc": 
            case "json": {
                return "application/json";
            }
            case "yml": 
            case "yaml": {
                return "application/x-yaml";
            }
            case "graphql": {
                return "application/graphql";
            }
            case "proto": {
                return "application/x-protobuf";
            }
            case "wsdl": 
            case "xsd": 
            case "xml": {
                return "application/xml";
            }
        }
        return null;
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setClientScope(String clientScope) {
        this.clientScope = clientScope;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected void logAndThrow(ApiException e) throws MojoExecutionException, MojoFailureException {
        if (e instanceof RuleViolationProblemDetails) {
            this.logAndThrow((RuleViolationProblemDetails)e);
        }
        if (e instanceof ProblemDetails) {
            this.logAndThrow((ProblemDetails)e);
        }
    }

    protected void logAndThrow(ProblemDetails e) throws MojoExecutionException {
        this.getLog().error((CharSequence)"---");
        this.getLog().error((CharSequence)("Error registering artifact: " + e.getName()));
        this.getLog().error((CharSequence)e.getTitle());
        this.getLog().error((CharSequence)e.getDetail());
        this.getLog().error((CharSequence)"---");
        throw new MojoExecutionException("Error registering artifact: " + e.getName(), (Exception)e);
    }

    protected void logAndThrow(RuleViolationProblemDetails e) throws MojoFailureException {
        this.getLog().error((CharSequence)"---");
        this.getLog().error((CharSequence)("Registry rule validation failure: " + e.getName()));
        this.getLog().error((CharSequence)e.getTitle());
        if (e.getCauses() != null) {
            e.getCauses().forEach(cause -> {
                this.getLog().error((CharSequence)("\t-> " + cause.getContext()));
                this.getLog().error((CharSequence)("\t   " + cause.getDescription()));
            });
        }
        this.getLog().error((CharSequence)"---");
        throw new MojoFailureException("Registry rule validation failure: " + e.getName(), (Throwable)e);
    }
}

