/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.ArraySchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.BooleanSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.CombinedSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.ConditionalSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.ConstSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.EnumSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.NotSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.NullSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.NumberSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.ObjectSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.PrimitiveSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.ReferenceSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.StringSchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ArraySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.BooleanSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.CombinedSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ConditionalSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ConstSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.EmptySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.EnumSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.FalseSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NotSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NullSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.NumberSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ObjectSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ReferenceSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.StringSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.TrueSchemaWrapper;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.ConstSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.NotSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;

public class SchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final Schema original;

    public SchemaDiffVisitor(DiffContext ctx, Schema original) {
        this.ctx = ctx;
        this.original = this.getReferencedOrOriginal(original);
    }

    private Schema getCompatibleSubschemaOrOriginal(Schema original, SchemaWrapper updated) {
        Objects.requireNonNull(original);
        Objects.requireNonNull(updated);
        if (original instanceof CombinedSchema) {
            Set typeCompatible = ((CombinedSchema)original).getSubschemas().stream().filter(s -> s.getClass().isInstance(updated.getWrapped())).collect(Collectors.toSet());
            if (CombinedSchema.ALL_CRITERION.equals(((CombinedSchema)original).getCriterion()) && typeCompatible.size() == 1) {
                return (Schema)typeCompatible.stream().findAny().get();
            }
        }
        return original;
    }

    private Schema getReferencedOrOriginal(Schema original) {
        Objects.requireNonNull(original);
        if (original instanceof ReferenceSchema) {
            original = ((ReferenceSchema)original).getReferredSchema();
        }
        return original;
    }

    @Override
    public void visitSchema(SchemaWrapper schema) {
        super.visitSchema(schema);
    }

    @Override
    public void visitStringSchema(StringSchemaWrapper stringSchema) {
        Schema subschema = this.getCompatibleSubschemaOrOriginal(this.original, stringSchema);
        if (subschema instanceof FalseSchema) {
            return;
        }
        if (!(subschema instanceof StringSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, subschema, stringSchema);
            return;
        }
        stringSchema.accept(new StringSchemaDiffVisitor(this.ctx, (StringSchema)subschema));
    }

    @Override
    public void visitArraySchema(ArraySchemaWrapper arraySchema) {
        if (this.original instanceof FalseSchema) {
            return;
        }
        if (!(this.original instanceof ArraySchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, this.original, arraySchema);
            return;
        }
        arraySchema.accept(new ArraySchemaDiffVisitor(this.ctx, (ArraySchema)this.original));
    }

    @Override
    public void visitEmptySchema(EmptySchemaWrapper schema) {
        schema.accept(new PrimitiveSchemaDiffVisitor(this.ctx, this.original));
    }

    @Override
    public void visitTrueSchema(TrueSchemaWrapper schema) {
        schema.accept(new PrimitiveSchemaDiffVisitor(this.ctx, this.original));
    }

    @Override
    public void visitFalseSchema(FalseSchemaWrapper schema) {
        schema.accept(new PrimitiveSchemaDiffVisitor(this.ctx, this.original));
    }

    @Override
    public void visitObjectSchema(ObjectSchemaWrapper schema) {
        if (this.original instanceof FalseSchema) {
            return;
        }
        if (!(this.original instanceof ObjectSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, this.original, schema);
            return;
        }
        schema.accept(new ObjectSchemaDiffVisitor(this.ctx, (ObjectSchema)this.original));
    }

    @Override
    public void visitBooleanSchema(BooleanSchemaWrapper schema) {
        Schema subschema = this.getCompatibleSubschemaOrOriginal(this.original, schema);
        if (subschema instanceof FalseSchema) {
            return;
        }
        if (!(subschema instanceof BooleanSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, subschema, schema);
            return;
        }
        schema.accept(new BooleanSchemaDiffVisitor(this.ctx, (BooleanSchema)subschema));
    }

    @Override
    public void visitConstSchema(ConstSchemaWrapper schema) {
        Set possibleValues;
        Schema orig = this.original;
        if (orig instanceof FalseSchema) {
            return;
        }
        if (orig instanceof EnumSchema && (possibleValues = ((EnumSchema)orig).getPossibleValues()).size() == 1) {
            orig = ConstSchema.builder().permittedValue(possibleValues.stream().findAny().get()).build();
        }
        if (!(orig instanceof ConstSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, orig, schema);
            return;
        }
        schema.accept(new ConstSchemaDiffVisitor(this.ctx, (ConstSchema)orig));
    }

    @Override
    public void visitEnumSchema(EnumSchemaWrapper schema) {
        Schema orig = this.original;
        if (orig instanceof FalseSchema) {
            return;
        }
        if (orig instanceof ConstSchema) {
            Object permittedValue = ((ConstSchema)orig).getPermittedValue();
            orig = EnumSchema.builder().possibleValue(permittedValue).build();
        }
        if (!(orig instanceof EnumSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, orig, schema);
            return;
        }
        schema.accept(new EnumSchemaDiffVisitor(this.ctx, (EnumSchema)orig));
    }

    @Override
    public void visitNullSchema(NullSchemaWrapper schema) {
        if (this.original instanceof FalseSchema) {
            return;
        }
        if (!(this.original instanceof NullSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, this.original, schema);
            return;
        }
        schema.accept(new NullSchemaDiffVisitor(this.ctx, (NullSchema)this.original));
    }

    @Override
    public void visitCombinedSchema(CombinedSchemaWrapper schema) {
        if (this.original instanceof FalseSchema) {
            return;
        }
        if (!(this.original instanceof CombinedSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, this.original, schema);
            return;
        }
        schema.accept(new CombinedSchemaDiffVisitor(this.ctx, (CombinedSchema)this.original));
    }

    @Override
    public void visitConditionalSchema(ConditionalSchemaWrapper schema) {
        if (this.original instanceof FalseSchema) {
            return;
        }
        if (!(this.original instanceof ConditionalSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, this.original, schema);
            return;
        }
        schema.accept(new ConditionalSchemaDiffVisitor(this.ctx, (ConditionalSchema)this.original));
    }

    @Override
    public void visitNotSchema(NotSchemaWrapper schema) {
        if (this.original instanceof FalseSchema) {
            return;
        }
        if (!(this.original instanceof NotSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, this.original, schema);
            return;
        }
        schema.accept(new NotSchemaDiffVisitor(this.ctx, (NotSchema)this.original));
    }

    @Override
    public void visitNumberSchema(NumberSchemaWrapper schema) {
        Schema subschema = this.getCompatibleSubschemaOrOriginal(this.original, schema);
        if (subschema instanceof FalseSchema) {
            return;
        }
        if (!(subschema instanceof NumberSchema)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, subschema, schema);
            return;
        }
        schema.accept(new NumberSchemaDiffVisitor(this.ctx, (NumberSchema)subschema));
    }

    @Override
    public void visitReferenceSchema(ReferenceSchemaWrapper schema) {
        if (this.original instanceof FalseSchema) {
            return;
        }
        schema.accept(new ReferenceSchemaDiffVisitor(this.ctx, this.original));
    }
}

