/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.EmptySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.FalseSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.TrueSchemaWrapper;
import org.everit.json.schema.EmptySchema;
import org.everit.json.schema.FalseSchema;
import org.everit.json.schema.Schema;

public class PrimitiveSchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final Schema original;

    public PrimitiveSchemaDiffVisitor(DiffContext ctx, Schema original) {
        this.ctx = ctx;
        this.original = original;
    }

    private void emptyTrueSchema(SchemaWrapper wrapper) {
        if (!EmptySchema.INSTANCE.equals((Object)this.original)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED_TO_EMPTY_OR_TRUE, this.original, wrapper);
        }
    }

    @Override
    public void visitEmptySchema(EmptySchemaWrapper emptySchema) {
        this.emptyTrueSchema(emptySchema);
        super.visitEmptySchema(emptySchema);
    }

    @Override
    public void visitTrueSchema(TrueSchemaWrapper trueSchema) {
        this.emptyTrueSchema(trueSchema);
        super.visitTrueSchema(trueSchema);
    }

    @Override
    public void visitFalseSchema(FalseSchemaWrapper falseSchema) {
        if (!FalseSchema.INSTANCE.equals((Object)this.original)) {
            this.ctx.addDifference(DiffType.SUBSCHEMA_TYPE_CHANGED, this.original, falseSchema);
        }
        super.visitFalseSchema(falseSchema);
    }
}

