/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types.provider;

import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.types.provider.AsyncApiArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.AvroArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.GraphQLArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.JsonArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.KConnectArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.OpenApiArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ProtobufArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.WsdlArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.XmlArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.XsdArtifactTypeUtilProvider;
import jakarta.ws.rs.core.MediaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultArtifactTypeUtilProviderImpl
implements ArtifactTypeUtilProviderFactory {
    protected Map<String, ArtifactTypeUtilProvider> map = new ConcurrentHashMap<String, ArtifactTypeUtilProvider>();
    protected List<ArtifactTypeUtilProvider> providers = new ArrayList<XsdArtifactTypeUtilProvider>(List.of(new AsyncApiArtifactTypeUtilProvider(), new AvroArtifactTypeUtilProvider(), new GraphQLArtifactTypeUtilProvider(), new JsonArtifactTypeUtilProvider(), new KConnectArtifactTypeUtilProvider(), new OpenApiArtifactTypeUtilProvider(), new ProtobufArtifactTypeUtilProvider(), new WsdlArtifactTypeUtilProvider(), new XmlArtifactTypeUtilProvider(), new XsdArtifactTypeUtilProvider()));

    @Override
    public ArtifactTypeUtilProvider getArtifactTypeProvider(String type) {
        return this.map.computeIfAbsent(type, t -> this.providers.stream().filter(a -> a.getArtifactType().equals(t)).findFirst().orElseThrow(() -> new IllegalStateException("No such artifact type provider: " + t)));
    }

    @Override
    public List<String> getAllArtifactTypes() {
        return this.providers.stream().map(a -> a.getArtifactType()).collect(Collectors.toList());
    }

    @Override
    public MediaType getArtifactMediaType(String type) {
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (type.equals("PROTOBUF")) {
            contentType = ArtifactMediaTypes.PROTO;
        }
        if (type.equals("GRAPHQL")) {
            contentType = ArtifactMediaTypes.GRAPHQL;
        }
        if (type.equals("WSDL") || type.equals("XSD") || type.equals("XML")) {
            contentType = ArtifactMediaTypes.XML;
        }
        return contentType;
    }
}

