/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroSchemaUtils;
import io.apicurio.registry.utils.IoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

public class AvroSchemaParser<U>
implements SchemaParser<Schema, U> {
    private AvroDatumProvider<U> avroDatumProvider;

    public AvroSchemaParser(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = avroDatumProvider;
    }

    public String artifactType() {
        return "AVRO";
    }

    public Schema parseSchema(byte[] rawSchema, Map<String, ParsedSchema<Schema>> resolvedReferences) {
        return AvroSchemaUtils.parse(IoUtil.toString((byte[])rawSchema), new ArrayList<ParsedSchema<Schema>>(resolvedReferences.values()));
    }

    public ParsedSchema<Schema> getSchemaFromData(Record<U> data) {
        Schema schema = this.avroDatumProvider.toSchema(data.payload());
        List<ParsedSchema<Schema>> resolvedReferences = this.handleReferences(schema);
        return new ParsedSchemaImpl().setParsedSchema((Object)schema).setReferenceName(schema.getFullName()).setSchemaReferences(resolvedReferences).setRawSchema(IoUtil.toBytes((String)schema.toString((Collection)resolvedReferences.stream().map(ParsedSchema::getParsedSchema).collect(Collectors.toSet()), false)));
    }

    public ParsedSchema<Schema> getSchemaFromData(Record<U> data, boolean dereference) {
        if (dereference) {
            Schema schema = this.avroDatumProvider.toSchema(data.payload());
            return new ParsedSchemaImpl().setParsedSchema((Object)schema).setReferenceName(schema.getFullName()).setRawSchema(IoUtil.toBytes((String)schema.toString()));
        }
        return this.getSchemaFromData(data);
    }

    private List<ParsedSchema<Schema>> handleReferences(Schema schema) {
        ArrayList<ParsedSchema<Schema>> schemaReferences = new ArrayList<ParsedSchema<Schema>>();
        switch (schema.getType()) {
            case RECORD: {
                schemaReferences.addAll(this.handleRecord(schema));
                break;
            }
            case UNION: {
                schemaReferences.addAll(this.handleUnion(schema));
                break;
            }
            case ENUM: {
                schemaReferences.add(this.handleEnum(schema));
                break;
            }
            case MAP: {
                schemaReferences.addAll(this.handleMap(schema));
                break;
            }
            case ARRAY: {
                schemaReferences.addAll(this.handleArray(schema));
            }
        }
        return schemaReferences;
    }

    private List<ParsedSchema<Schema>> handleUnion(Schema schema) {
        ArrayList<ParsedSchema<Schema>> schemaReferences = new ArrayList<ParsedSchema<Schema>>();
        for (Schema type : schema.getTypes()) {
            if (!this.isComplexType(type.getType())) continue;
            this.addComplexTypeSubSchema(schemaReferences, type);
        }
        return schemaReferences;
    }

    private List<ParsedSchema<Schema>> handleMap(Schema schema) {
        ArrayList<ParsedSchema<Schema>> schemaReferences = new ArrayList<ParsedSchema<Schema>>();
        Schema elementSchema = schema.getValueType();
        if (this.isComplexType(schema.getValueType().getType())) {
            this.addComplexTypeSubSchema(schemaReferences, elementSchema);
        }
        return schemaReferences;
    }

    private List<ParsedSchema<Schema>> handleArray(Schema schema) {
        ArrayList<ParsedSchema<Schema>> schemaReferences = new ArrayList<ParsedSchema<Schema>>();
        Schema elementSchema = schema.getElementType();
        if (this.isComplexType(schema.getElementType().getType())) {
            this.addComplexTypeSubSchema(schemaReferences, elementSchema);
        }
        return schemaReferences;
    }

    private void addComplexTypeSubSchema(List<ParsedSchema<Schema>> schemaReferences, Schema elementSchema) {
        if (elementSchema.getType().equals((Object)Schema.Type.ENUM)) {
            schemaReferences.add(this.parseSchema(elementSchema, Collections.emptyList()));
        } else if (elementSchema.getType().equals((Object)Schema.Type.RECORD)) {
            ArrayList<ParsedSchema<Schema>> nestedReferences = new ArrayList<ParsedSchema<Schema>>(this.handleReferences(elementSchema));
            schemaReferences.add(this.parseSchema(elementSchema, nestedReferences));
        }
    }

    private List<ParsedSchema<Schema>> handleRecord(Schema schema) {
        ArrayList<ParsedSchema<Schema>> schemaReferences = new ArrayList<ParsedSchema<Schema>>();
        for (Schema.Field field : schema.getFields()) {
            if (field.schema().getType().equals((Object)Schema.Type.RECORD)) {
                List<ParsedSchema<Schema>> parsedSchemas = this.handleReferences(field.schema());
                byte[] rawSchema = IoUtil.toBytes((String)field.schema().toString((Collection)parsedSchemas.stream().map(ParsedSchema::getParsedSchema).collect(Collectors.toSet()), false));
                ParsedSchemaImpl referencedSchema = new ParsedSchemaImpl().setParsedSchema((Object)field.schema()).setReferenceName(field.schema().getFullName()).setSchemaReferences(parsedSchemas).setRawSchema(rawSchema);
                schemaReferences.add((ParsedSchema<Schema>)referencedSchema);
                continue;
            }
            if (field.schema().getType().equals((Object)Schema.Type.UNION)) {
                schemaReferences.addAll(this.handleUnion(field.schema()));
                continue;
            }
            if (field.schema().getType().equals((Object)Schema.Type.ARRAY)) {
                schemaReferences.addAll(this.handleArray(field.schema()));
                continue;
            }
            if (field.schema().getType().equals((Object)Schema.Type.MAP)) {
                schemaReferences.addAll(this.handleMap(field.schema()));
                continue;
            }
            if (!field.schema().getType().equals((Object)Schema.Type.ENUM)) continue;
            schemaReferences.add(this.handleEnum(field.schema()));
        }
        return schemaReferences;
    }

    private ParsedSchema<Schema> parseSchema(Schema schema, List<ParsedSchema<Schema>> schemaReferences) {
        byte[] rawSchema = IoUtil.toBytes((String)schema.toString((Collection)schemaReferences.stream().map(ParsedSchema::getParsedSchema).collect(Collectors.toSet()), false));
        return new ParsedSchemaImpl().setParsedSchema((Object)schema).setReferenceName(schema.getFullName()).setSchemaReferences(schemaReferences).setRawSchema(rawSchema);
    }

    private ParsedSchema<Schema> handleEnum(Schema schema) {
        byte[] rawSchema = IoUtil.toBytes((String)schema.toString());
        return new ParsedSchemaImpl().setParsedSchema((Object)schema).setReferenceName(schema.getFullName()).setSchemaReferences(Collections.emptyList()).setRawSchema(rawSchema);
    }

    public boolean isComplexType(Schema.Type type) {
        return type == Schema.Type.ARRAY || type == Schema.Type.MAP || type == Schema.Type.RECORD || type == Schema.Type.ENUM || type == Schema.Type.UNION;
    }
}

