/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.interceptors;

import io.appium.java_client.proxy.MethodCallListener;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public abstract class InterceptorOfASingleElement
implements MethodCallListener {
    protected final ElementLocator locator;
    protected final WebDriver driver;

    public InterceptorOfASingleElement(ElementLocator locator, WebDriver driver) {
        this.locator = locator;
        this.driver = driver;
    }

    protected abstract Object getObject(WebElement var1, Method var2, Object[] var3) throws Throwable;

    @Override
    public Object call(Object obj, Method method, Object[] args, Callable<?> original) throws Throwable {
        if (method.getName().equals("toString") && args.length == 0) {
            return this.locator.toString();
        }
        if (Object.class.equals(method.getDeclaringClass())) {
            return original.call();
        }
        if (WrapsDriver.class.isAssignableFrom(method.getDeclaringClass()) && method.getName().equals("getWrappedDriver")) {
            return this.driver;
        }
        WebElement realElement = this.locator.findElement();
        return this.getObject(realElement, method, args);
    }
}

