/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.pagefactory.AndroidFindAll;
import io.appium.java_client.pagefactory.AndroidFindBy;
import io.appium.java_client.pagefactory.AndroidFindBys;
import io.appium.java_client.pagefactory.HowToUseLocators;
import io.appium.java_client.pagefactory.LocatorGroupStrategy;
import io.appium.java_client.pagefactory.bys.ContentMappedBy;
import io.appium.java_client.pagefactory.bys.ContentType;
import io.appium.java_client.pagefactory.bys.builder.AppiumByBuilder;
import io.appium.java_client.pagefactory.bys.builder.ByChained;
import io.appium.java_client.pagefactory.bys.builder.HowToUseSelectors;
import io.appium.java_client.pagefactory.iOSXCUITFindAll;
import io.appium.java_client.pagefactory.iOSXCUITFindBy;
import io.appium.java_client.pagefactory.iOSXCUITFindBys;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.ByAll;

public class DefaultElementByBuilder
extends AppiumByBuilder {
    private static final String PRIORITY = "priority";
    private static final String VALUE = "value";
    private static final Class<?>[] ANNOTATION_ARGUMENTS = new Class[0];
    private static final Object[] ANNOTATION_PARAMETERS = new Object[0];

    public DefaultElementByBuilder(String platform, String automation) {
        super(platform, automation);
    }

    private static void checkDisallowedAnnotationPairs(Annotation a1, Annotation a2) throws IllegalArgumentException {
        if (a1 != null && a2 != null) {
            throw new IllegalArgumentException("If you use a '@" + a1.getClass().getSimpleName() + "' annotation, you must not also use a '@" + a2.getClass().getSimpleName() + "' annotation");
        }
    }

    private static By buildMobileBy(LocatorGroupStrategy locatorGroupStrategy, By[] bys) {
        if (bys.length == 0) {
            return null;
        }
        LocatorGroupStrategy strategy = Optional.ofNullable(locatorGroupStrategy).orElse(LocatorGroupStrategy.CHAIN);
        if (strategy.equals((Object)LocatorGroupStrategy.ALL_POSSIBLE)) {
            return new ByAll(bys);
        }
        return new ByChained(bys);
    }

    @Override
    protected void assertValidAnnotations() {
        AnnotatedElement annotatedElement = this.annotatedElementContainer.getAnnotated();
        FindBy findBy = annotatedElement.getAnnotation(FindBy.class);
        FindBys findBys = annotatedElement.getAnnotation(FindBys.class);
        DefaultElementByBuilder.checkDisallowedAnnotationPairs((Annotation)findBy, (Annotation)findBys);
        FindAll findAll = annotatedElement.getAnnotation(FindAll.class);
        DefaultElementByBuilder.checkDisallowedAnnotationPairs((Annotation)findBy, (Annotation)findAll);
        DefaultElementByBuilder.checkDisallowedAnnotationPairs((Annotation)findBys, (Annotation)findAll);
    }

    @Override
    protected By buildDefaultBy() {
        FindAll findAll;
        FindBys findBys;
        AnnotatedElement annotatedElement = this.annotatedElementContainer.getAnnotated();
        By defaultBy = null;
        FindBy findBy = annotatedElement.getAnnotation(FindBy.class);
        if (findBy != null) {
            defaultBy = new FindBy.FindByBuilder().buildIt((Object)findBy, (Field)annotatedElement);
        }
        if (defaultBy == null && (findBys = annotatedElement.getAnnotation(FindBys.class)) != null) {
            defaultBy = new FindBys.FindByBuilder().buildIt((Object)findBys, (Field)annotatedElement);
        }
        if (defaultBy == null && (findAll = annotatedElement.getAnnotation(FindAll.class)) != null) {
            defaultBy = new FindAll.FindByBuilder().buildIt((Object)findAll, (Field)annotatedElement);
        }
        return defaultBy;
    }

    private By[] getBys(Class<? extends Annotation> singleLocator, Class<? extends Annotation> chainedLocator, Class<? extends Annotation> allLocator) {
        AnnotationComparator comparator = new AnnotationComparator();
        AnnotatedElement annotatedElement = this.annotatedElementContainer.getAnnotated();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(Arrays.asList(annotatedElement.getAnnotationsByType(singleLocator)));
        annotations.addAll(Arrays.asList(annotatedElement.getAnnotationsByType(chainedLocator)));
        annotations.addAll(Arrays.asList(annotatedElement.getAnnotationsByType(allLocator)));
        annotations.sort(comparator);
        ArrayList<By> result = new ArrayList<By>();
        for (Annotation a : annotations) {
            Annotation[] subLocators;
            Class<? extends Annotation> annotationClass = a.annotationType();
            if (singleLocator.equals(annotationClass)) {
                result.add(DefaultElementByBuilder.createBy(new Annotation[]{a}, HowToUseSelectors.USE_ONE));
                continue;
            }
            try {
                Method value = annotationClass.getMethod(VALUE, ANNOTATION_ARGUMENTS);
                subLocators = (Annotation[])value.invoke((Object)a, ANNOTATION_PARAMETERS);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new ClassCastException(String.format("The annotation '%s' has no convenient '%s' method which returns array of annotations", annotationClass.getName(), VALUE));
            }
            Arrays.sort(subLocators, comparator);
            if (chainedLocator.equals(annotationClass)) {
                result.add(DefaultElementByBuilder.createBy(subLocators, HowToUseSelectors.BUILD_CHAINED));
                continue;
            }
            if (!allLocator.equals(annotationClass)) continue;
            result.add(DefaultElementByBuilder.createBy(subLocators, HowToUseSelectors.USE_ANY));
        }
        return result.toArray(new By[0]);
    }

    @Override
    protected By buildMobileNativeBy() {
        AnnotatedElement annotatedElement = this.annotatedElementContainer.getAnnotated();
        HowToUseLocators howToUseLocators = annotatedElement.getAnnotation(HowToUseLocators.class);
        Optional<HowToUseLocators> howToUseLocatorsOptional = Optional.ofNullable(howToUseLocators);
        if (this.isAndroid()) {
            return DefaultElementByBuilder.buildMobileBy(howToUseLocatorsOptional.map(HowToUseLocators::androidAutomation).orElse(null), this.getBys(AndroidFindBy.class, AndroidFindBys.class, AndroidFindAll.class));
        }
        if (this.isIOSXcuit() || this.isIOS() || this.isTvOS()) {
            return DefaultElementByBuilder.buildMobileBy(howToUseLocatorsOptional.map(HowToUseLocators::iOSXCUITAutomation).orElse(null), this.getBys(iOSXCUITFindBy.class, iOSXCUITFindBys.class, iOSXCUITFindAll.class));
        }
        return null;
    }

    @Override
    public boolean isLookupCached() {
        AnnotatedElement annotatedElement = this.annotatedElementContainer.getAnnotated();
        return annotatedElement.getAnnotation(CacheLookup.class) != null;
    }

    private By returnMappedBy(By byDefault, By nativeAppBy) {
        HashMap<ContentType, By> contentMap = new HashMap<ContentType, By>();
        contentMap.put(ContentType.HTML_OR_DEFAULT, byDefault);
        contentMap.put(ContentType.NATIVE_MOBILE_SPECIFIC, nativeAppBy);
        return new ContentMappedBy(contentMap);
    }

    @Override
    public By buildBy() {
        this.assertValidAnnotations();
        By defaultBy = this.buildDefaultBy();
        By mobileNativeBy = this.buildMobileNativeBy();
        String idOrName = ((Field)this.annotatedElementContainer.getAnnotated()).getName();
        if (defaultBy == null && mobileNativeBy == null) {
            defaultBy = new ByIdOrName(((Field)this.annotatedElementContainer.getAnnotated()).getName());
            mobileNativeBy = new By.ById(idOrName);
            return this.returnMappedBy(defaultBy, mobileNativeBy);
        }
        if (defaultBy == null) {
            defaultBy = new ByIdOrName(((Field)this.annotatedElementContainer.getAnnotated()).getName());
            return this.returnMappedBy(defaultBy, mobileNativeBy);
        }
        if (mobileNativeBy == null) {
            mobileNativeBy = defaultBy;
            return this.returnMappedBy(defaultBy, mobileNativeBy);
        }
        return this.returnMappedBy(defaultBy, mobileNativeBy);
    }

    private static class AnnotationComparator
    implements Comparator<Annotation> {
        private AnnotationComparator() {
        }

        private static Method getPriorityMethod(Class<? extends Annotation> clazz) {
            try {
                return clazz.getMethod(DefaultElementByBuilder.PRIORITY, ANNOTATION_ARGUMENTS);
            }
            catch (NoSuchMethodException e) {
                throw new ClassCastException(String.format("Class %s has no '%s' method", clazz.getName(), DefaultElementByBuilder.PRIORITY));
            }
        }

        private static int getPriorityValue(Method priorityMethod, Annotation annotation, Class<? extends Annotation> clazz) {
            try {
                return (Integer)priorityMethod.invoke((Object)annotation, ANNOTATION_PARAMETERS);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("It is impossible to get priority. Annotation class: %s", clazz.toString()), e);
            }
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            Class<? extends Annotation> c1 = o1.annotationType();
            Class<? extends Annotation> c2 = o2.annotationType();
            Method priority1 = AnnotationComparator.getPriorityMethod(c1);
            Method priority2 = AnnotationComparator.getPriorityMethod(c2);
            int p1 = AnnotationComparator.getPriorityValue(priority1, o1, c1);
            int p2 = AnnotationComparator.getPriorityValue(priority2, o2, c2);
            return Integer.signum(p1 - p2);
        }
    }
}

