/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory.interceptors;

import io.appium.java_client.proxy.MethodCallListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public abstract class InterceptorOfASingleElement
implements MethodCallListener {
    protected final ElementLocator locator;
    private final WeakReference<WebDriver> driverReference;

    public InterceptorOfASingleElement(@Nullable ElementLocator locator, WeakReference<WebDriver> driverReference) {
        this.locator = locator;
        this.driverReference = driverReference;
    }

    protected abstract Object getObject(WebElement var1, Method var2, Object[] var3) throws Throwable;

    private static boolean areElementsEqual(Object we1, Object we2) {
        if (!(we1 instanceof RemoteWebElement) || !(we2 instanceof RemoteWebElement)) {
            return false;
        }
        return we1 == we2 || Objects.equals(((RemoteWebElement)we1).getId(), ((RemoteWebElement)we2).getId());
    }

    @Override
    public Object call(Object obj, Method method, Object[] args, Callable<?> original) throws Throwable {
        if (this.locator == null) {
            return original.call();
        }
        if (method.getName().equals("toString") && args.length == 0) {
            return this.locator.toString();
        }
        if (Object.class == method.getDeclaringClass()) {
            return original.call();
        }
        if (WrapsDriver.class.isAssignableFrom(method.getDeclaringClass()) && method.getName().equals("getWrappedDriver")) {
            return this.driverReference.get();
        }
        WebElement realElement = this.locator.findElement();
        if ("equals".equals(method.getName()) && args.length == 1) {
            return InterceptorOfASingleElement.areElementsEqual(realElement, args[0]);
        }
        return this.getObject(realElement, method, args);
    }
}

