/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote.options;

import io.appium.java_client.remote.options.CanSetCapability;
import io.appium.java_client.remote.options.SupportsAutomationNameOption;
import io.appium.java_client.remote.options.SupportsBrowserNameOption;
import io.appium.java_client.remote.options.SupportsEventTimingsOption;
import io.appium.java_client.remote.options.SupportsFullResetOption;
import io.appium.java_client.remote.options.SupportsNewCommandTimeoutOption;
import io.appium.java_client.remote.options.SupportsNoResetOption;
import io.appium.java_client.remote.options.SupportsPlatformVersionOption;
import io.appium.java_client.remote.options.SupportsPrintPageSourceOnFindFailureOption;
import io.appium.java_client.remote.options.SupportsWebSocketUrlOption;
import io.appium.java_client.remote.options.W3CCapabilityKeys;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;

public class BaseOptions<T extends BaseOptions<T>>
extends MutableCapabilities
implements CanSetCapability<T>,
SupportsAutomationNameOption<T>,
SupportsEventTimingsOption<T>,
SupportsPrintPageSourceOnFindFailureOption<T>,
SupportsNoResetOption<T>,
SupportsFullResetOption<T>,
SupportsNewCommandTimeoutOption<T>,
SupportsBrowserNameOption<T>,
SupportsPlatformVersionOption<T>,
SupportsWebSocketUrlOption<T> {
    public BaseOptions() {
    }

    public BaseOptions(Map<String, ?> source) {
        super(source);
    }

    public BaseOptions(Capabilities source) {
        super(source);
    }

    public T setPlatformName(String platform) {
        return (T)this.amend("platformName", platform);
    }

    @Nullable
    public Platform getPlatformName() {
        return Optional.ofNullable(this.getCapability("platformName")).map(cap -> {
            if (cap instanceof Platform) {
                return (Platform)cap;
            }
            try {
                return Platform.fromString((String)String.valueOf(cap));
            }
            catch (WebDriverException e) {
                return null;
            }
        }).orElse(null);
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(super.asMap().entrySet().stream().collect(Collectors.toMap(entry -> BaseOptions.toW3cName((String)entry.getKey()), Map.Entry::getValue)));
    }

    public T merge(Capabilities extraCapabilities) {
        Object result = this.clone();
        extraCapabilities.asMap().forEach((arg_0, arg_1) -> BaseOptions.lambda$merge$2((BaseOptions)result, arg_0, arg_1));
        return (T)result;
    }

    public T clone() {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Capabilities.class);
            return (T)((BaseOptions)constructor.newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setCapability(String key, @Nullable Object value) {
        Require.nonNull((String)"Capability name", (Object)key);
        super.setCapability(BaseOptions.toW3cName(key), value);
    }

    @Nullable
    public Object getCapability(String capabilityName) {
        Object value = super.getCapability(capabilityName);
        return value == null ? super.getCapability("appium:" + capabilityName) : value;
    }

    public static String toW3cName(String capName) {
        return W3CCapabilityKeys.INSTANCE.test(capName) ? capName : "appium:" + capName;
    }

    private static /* synthetic */ void lambda$merge$2(BaseOptions result, String key, Object value) {
        if (value != null) {
            result.setCapability(key, value);
        }
    }
}

