/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Binding;
import io.asyncer.r2dbc.mysql.CommitRollbackState;
import io.asyncer.r2dbc.mysql.CreateSavepointState;
import io.asyncer.r2dbc.mysql.MultiQueryExchangeable;
import io.asyncer.r2dbc.mysql.PrepareExchangeable;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.QueryLogger;
import io.asyncer.r2dbc.mysql.SimpleQueryExchangeable;
import io.asyncer.r2dbc.mysql.StartTransactionState;
import io.asyncer.r2dbc.mysql.TextQueryExchangeable;
import io.asyncer.r2dbc.mysql.TransactionBatchExchangeable;
import io.asyncer.r2dbc.mysql.TransactionMultiExchangeable;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.message.client.PingMessage;
import io.asyncer.r2dbc.mysql.message.client.TextQueryMessage;
import io.asyncer.r2dbc.mysql.message.server.CompleteMessage;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.r2dbc.spi.TransactionDefinition;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

final class QueryFlow {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(QueryFlow.class);
    private static final Predicate<ServerMessage> RESULT_DONE = message -> message instanceof CompleteMessage;
    private static final Consumer<ServerMessage> EXECUTE_VOID = message -> {
        if (message instanceof ErrorMessage) {
            throw ((ErrorMessage)message).toException();
        }
        if (message instanceof ReferenceCounted) {
            ReferenceCountUtil.safeRelease((Object)message);
        }
    };
    private static final BiConsumer<ServerMessage, SynchronousSink<ServerMessage>> PING = (message, sink) -> {
        if (message instanceof ErrorMessage) {
            sink.next(message);
            sink.complete();
        } else if (message instanceof CompleteMessage && ((CompleteMessage)message).isDone()) {
            sink.next(message);
            sink.complete();
        } else {
            ReferenceCountUtil.safeRelease((Object)message);
        }
    };

    static Flux<Flux<ServerMessage>> execute(Client client, String sql, List<Binding> bindings, int fetchSize) {
        return Flux.defer(() -> {
            if (bindings.isEmpty()) {
                return Flux.empty();
            }
            return client.exchange(new PrepareExchangeable(client, sql, bindings.iterator(), fetchSize)).windowUntil(RESULT_DONE);
        });
    }

    static Flux<Flux<ServerMessage>> execute(Client client, Query query, String returning, List<Binding> bindings) {
        return Flux.defer(() -> {
            if (bindings.isEmpty()) {
                return Flux.empty();
            }
            return client.exchange(new TextQueryExchangeable(query, returning, bindings.iterator())).windowUntil(RESULT_DONE);
        });
    }

    static Flux<Flux<ServerMessage>> execute(Client client, String sql) {
        return Flux.defer(() -> QueryFlow.execute0(client, sql).windowUntil(RESULT_DONE));
    }

    static Flux<Flux<ServerMessage>> execute(Client client, List<String> statements) {
        return Flux.defer(() -> {
            switch (statements.size()) {
                case 0: {
                    return Flux.empty();
                }
                case 1: {
                    return QueryFlow.execute0(client, (String)statements.get(0)).windowUntil(RESULT_DONE);
                }
            }
            return client.exchange(new MultiQueryExchangeable(statements.iterator())).windowUntil(RESULT_DONE);
        });
    }

    static Mono<Void> executeVoid(Client client, String sql) {
        return Mono.defer(() -> client.exchange(new TextQueryMessage(sql), (message, sink) -> {
            if (message instanceof ErrorMessage) {
                sink.next((Object)((ErrorMessage)message).offendedBy(sql));
                sink.complete();
            } else {
                sink.next(message);
                if (message instanceof CompleteMessage && ((CompleteMessage)message).isDone()) {
                    sink.complete();
                }
            }
        }).doOnSubscribe(ignored -> QueryLogger.log(sql)).doOnNext(EXECUTE_VOID).then());
    }

    static Mono<Void> beginTransaction(Client client, boolean batchSupported, TransactionDefinition definition) {
        StartTransactionState startState = new StartTransactionState(client, definition);
        if (batchSupported) {
            return client.exchange(new TransactionBatchExchangeable(startState)).then();
        }
        return client.exchange(new TransactionMultiExchangeable(startState)).then();
    }

    static Mono<Void> doneTransaction(Client client, boolean commit, boolean batchSupported) {
        CommitRollbackState commitState = new CommitRollbackState(client, commit);
        if (batchSupported) {
            return client.exchange(new TransactionBatchExchangeable(commitState)).then();
        }
        return client.exchange(new TransactionMultiExchangeable(commitState)).then();
    }

    static Mono<Void> createSavepoint(Client client, String name, boolean batchSupported) {
        CreateSavepointState savepointState = new CreateSavepointState(client, name);
        if (batchSupported) {
            return client.exchange(new TransactionBatchExchangeable(savepointState)).then();
        }
        return client.exchange(new TransactionMultiExchangeable(savepointState)).then();
    }

    static Flux<ServerMessage> ping(Client client) {
        return client.exchange(PingMessage.INSTANCE, PING);
    }

    static Mono<Void> setSessionVariable(Client client, String variable) {
        if (variable.isEmpty()) {
            return Mono.empty();
        }
        if (variable.startsWith("@")) {
            return QueryFlow.executeVoid(client, "SET " + variable);
        }
        return QueryFlow.executeVoid(client, "SET SESSION " + variable);
    }

    static Mono<Void> setSessionVariables(Client client, List<String> sessionVariables) {
        switch (sessionVariables.size()) {
            case 0: {
                return Mono.empty();
            }
            case 1: {
                return QueryFlow.setSessionVariable(client, sessionVariables.get(0));
            }
        }
        StringBuilder query = new StringBuilder(sessionVariables.size() * 32 + 16).append("SET ");
        boolean comma = false;
        for (String variable : sessionVariables) {
            if (variable.isEmpty()) continue;
            if (comma) {
                query.append(',');
            } else {
                comma = true;
            }
            if (variable.startsWith("@")) {
                query.append(variable);
                continue;
            }
            query.append("SESSION ").append(variable);
        }
        return QueryFlow.executeVoid(client, query.toString());
    }

    private static Flux<ServerMessage> execute0(Client client, String sql) {
        return client.exchange(new SimpleQueryExchangeable(sql));
    }

    private QueryFlow() {
    }
}

