/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.ServerVersion;
import io.asyncer.r2dbc.mysql.cache.PrepareCache;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.constant.ZeroDateOption;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.r2dbc.spi.IsolationLevel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneId;
import org.jetbrains.annotations.Nullable;

public final class ConnectionContext
implements CodecContext {
    private static final ServerVersion NONE_VERSION = ServerVersion.create(0, 0, 0);
    private static final ServerVersion MYSQL_5_7_4 = ServerVersion.create(5, 7, 4);
    private static final ServerVersion MARIA_10_1_1 = ServerVersion.create(10, 1, 1, true);
    private final ZeroDateOption zeroDateOption;
    @Nullable
    private final Path localInfilePath;
    private final int localInfileBufferSize;
    private final boolean preserveInstants;
    private int connectionId = -1;
    private ServerVersion serverVersion = NONE_VERSION;
    private Capability capability = Capability.DEFAULT;
    private PrepareCache prepareCache;
    @Nullable
    private ZoneId timeZone;
    private String product = "Unknown";
    private volatile IsolationLevel currentIsolationLevel;
    private volatile IsolationLevel sessionIsolationLevel;
    private boolean lockWaitTimeoutSupported = false;
    private volatile Duration currentLockWaitTimeout;
    private volatile Duration sessionLockWaitTimeout;
    private volatile short serverStatuses = (short)2;

    ConnectionContext(ZeroDateOption zeroDateOption, @Nullable Path localInfilePath, int localInfileBufferSize, boolean preserveInstants, @Nullable ZoneId timeZone) {
        this.zeroDateOption = AssertUtils.requireNonNull(zeroDateOption, "zeroDateOption must not be null");
        this.localInfilePath = localInfilePath;
        this.localInfileBufferSize = localInfileBufferSize;
        this.preserveInstants = preserveInstants;
        this.timeZone = timeZone;
    }

    void initHandshake(int connectionId, ServerVersion version, Capability capability) {
        this.connectionId = connectionId;
        this.serverVersion = version;
        this.capability = capability;
    }

    void initSession(PrepareCache prepareCache, IsolationLevel isolationLevel, boolean lockWaitTimeoutSupported, Duration lockWaitTimeout, @Nullable String product, @Nullable ZoneId timeZone) {
        this.prepareCache = prepareCache;
        this.currentIsolationLevel = this.sessionIsolationLevel = isolationLevel;
        this.lockWaitTimeoutSupported = lockWaitTimeoutSupported;
        this.currentLockWaitTimeout = this.sessionLockWaitTimeout = lockWaitTimeout;
        String string = this.product = product == null ? "Unknown" : product;
        if (timeZone != null) {
            if (this.isTimeZoneInitialized()) {
                throw new IllegalStateException("Connection timezone have been initialized");
            }
            this.timeZone = timeZone;
        }
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public Capability getCapability() {
        return this.capability;
    }

    @Override
    public CharCollation getClientCollation() {
        return CharCollation.clientCharCollation();
    }

    @Override
    public boolean isPreserveInstants() {
        return this.preserveInstants;
    }

    @Override
    public ZoneId getTimeZone() {
        if (this.timeZone == null) {
            throw new IllegalStateException("Server timezone have not initialization");
        }
        return this.timeZone;
    }

    String getProduct() {
        return this.product;
    }

    PrepareCache getPrepareCache() {
        return this.prepareCache;
    }

    boolean isTimeZoneInitialized() {
        return this.timeZone != null;
    }

    @Override
    public boolean isMariaDb() {
        Capability capability = this.capability;
        return capability != null && capability.isMariaDb() || this.serverVersion.isMariaDb();
    }

    public boolean isNoBackslashEscapes() {
        return (this.serverStatuses & 0x200) != 0;
    }

    @Override
    public ZeroDateOption getZeroDateOption() {
        return this.zeroDateOption;
    }

    @Nullable
    public Path getLocalInfilePath() {
        return this.localInfilePath;
    }

    public int getLocalInfileBufferSize() {
        return this.localInfileBufferSize;
    }

    public boolean isLockWaitTimeoutSupported() {
        return this.lockWaitTimeoutSupported;
    }

    public boolean isStatementTimeoutSupported() {
        boolean isMariaDb = this.isMariaDb();
        return isMariaDb && this.serverVersion.isGreaterThanOrEqualTo(MARIA_10_1_1) || !isMariaDb && this.serverVersion.isGreaterThanOrEqualTo(MYSQL_5_7_4);
    }

    public short getServerStatuses() {
        return this.serverStatuses;
    }

    public void setServerStatuses(short serverStatuses) {
        this.serverStatuses = serverStatuses;
    }

    IsolationLevel getCurrentIsolationLevel() {
        return this.currentIsolationLevel;
    }

    void setCurrentIsolationLevel(IsolationLevel isolationLevel) {
        this.currentIsolationLevel = isolationLevel;
    }

    void resetCurrentIsolationLevel() {
        this.currentIsolationLevel = this.sessionIsolationLevel;
    }

    IsolationLevel getSessionIsolationLevel() {
        return this.sessionIsolationLevel;
    }

    void setSessionIsolationLevel(IsolationLevel isolationLevel) {
        this.sessionIsolationLevel = isolationLevel;
    }

    void setCurrentLockWaitTimeout(Duration timeoutSeconds) {
        this.currentLockWaitTimeout = timeoutSeconds;
    }

    void resetCurrentLockWaitTimeout() {
        this.currentLockWaitTimeout = this.sessionLockWaitTimeout;
    }

    boolean isLockWaitTimeoutChanged() {
        return this.currentLockWaitTimeout != this.sessionLockWaitTimeout;
    }

    Duration getSessionLockWaitTimeout() {
        return this.sessionLockWaitTimeout;
    }

    void setAllLockWaitTimeout(Duration timeoutSeconds) {
        this.currentLockWaitTimeout = this.sessionLockWaitTimeout = timeoutSeconds;
    }

    boolean isInTransaction() {
        return (this.serverStatuses & 1) != 0;
    }

    boolean isAutoCommit() {
        short serverStatuses = this.serverStatuses;
        return (serverStatuses & 1) == 0 && (serverStatuses & 2) != 0;
    }
}

