/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlColumnDescriptor;
import io.asyncer.r2dbc.mysql.MySqlRowDescriptor;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.api.MySqlRow;
import io.asyncer.r2dbc.mysql.api.MySqlRowMetadata;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import java.lang.reflect.ParameterizedType;

final class MySqlDataRow
implements MySqlRow {
    private final FieldValue[] fields;
    private final MySqlRowDescriptor rowMetadata;
    private final Codecs codecs;
    private final boolean binary;
    private final CodecContext context;

    MySqlDataRow(FieldValue[] fields, MySqlRowDescriptor rowMetadata, Codecs codecs, boolean binary, CodecContext context) {
        this.fields = AssertUtils.requireNonNull(fields, "fields must not be null");
        this.rowMetadata = AssertUtils.requireNonNull(rowMetadata, "rowMetadata must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.binary = binary;
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
    }

    public <T> T get(int index, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(index);
        return this.codecs.decode(this.fields[index], (MySqlReadableMetadata)info, type, this.binary, this.context);
    }

    public <T> T get(String name, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(name);
        return this.codecs.decode(this.fields[info.getIndex()], (MySqlReadableMetadata)info, type, this.binary, this.context);
    }

    @Override
    public <T> T get(int index, ParameterizedType type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(index);
        return this.codecs.decode(this.fields[index], (MySqlReadableMetadata)info, type, this.binary, this.context);
    }

    @Override
    public <T> T get(String name, ParameterizedType type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(name);
        return this.codecs.decode(this.fields[info.getIndex()], (MySqlReadableMetadata)info, type, this.binary, this.context);
    }

    @Override
    public MySqlRowMetadata getMetadata() {
        return this.rowMetadata;
    }
}

