/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.BaseFluxExchangeable;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.QueryLogger;
import io.asyncer.r2dbc.mysql.message.client.TextQueryMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.SynchronousSink;

final class SimpleQueryExchangeable
extends BaseFluxExchangeable {
    private static final int INIT = 0;
    private static final int EXECUTE = 1;
    private static final int DISPOSE = 2;
    private final AtomicInteger state = new AtomicInteger(0);
    private final String sql;

    SimpleQueryExchangeable(String sql) {
        this.sql = sql;
    }

    public void dispose() {
        if (this.state.getAndSet(2) != 2) {
            this.requests.tryEmitComplete();
        }
    }

    public boolean isDisposed() {
        return this.state.get() == 2;
    }

    @Override
    protected void tryNextOrComplete(@Nullable SynchronousSink<ServerMessage> sink) {
        if (this.state.compareAndSet(0, 1)) {
            QueryLogger.log(this.sql);
            Sinks.EmitResult result = this.requests.tryEmitNext((Object)new TextQueryMessage(this.sql));
            if (result == Sinks.EmitResult.OK) {
                return;
            }
            QueryFlow.logger.error("Emit request failed due to {}", (Object)result);
        }
        if (sink != null) {
            sink.complete();
        }
    }

    @Override
    protected String offendingSql() {
        return this.sql;
    }
}

