/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.internal.util;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZoneOffset;

public final class StringUtils {
    private static final char QUOTE = '`';
    private static final String ZONE_PREFIX_POSIX = "posix/";
    private static final String ZONE_PREFIX_RIGHT = "right/";
    private static final int ZONE_PREFIX_LENGTH = 6;

    public static String quoteIdentifier(String identifier) {
        AssertUtils.requireNonEmpty(identifier, "identifier must not be empty");
        int index = identifier.indexOf(96);
        if (index == -1) {
            return '`' + identifier + '`';
        }
        int len = identifier.length();
        StringBuilder builder = new StringBuilder(len + 10).append('`');
        int fromIndex = 0;
        while (index != -1) {
            builder.append(identifier, fromIndex, index).append('`').append('`');
            fromIndex = index + 1;
            index = identifier.indexOf(96, fromIndex);
        }
        if (fromIndex < len) {
            builder.append(identifier, fromIndex, len);
        }
        return builder.append('`').toString();
    }

    public static String extendReturning(String sql, String returning) {
        return returning.isEmpty() ? sql : sql + " RETURNING " + returning;
    }

    public static String statementTimeoutVariable(Duration timeout, boolean isMariaDb) {
        if (isMariaDb) {
            double seconds = (double)timeout.getSeconds() + (double)timeout.getNano() / 1.0E9;
            return "max_statement_time=" + seconds;
        }
        return "max_execution_time=" + timeout.toMillis();
    }

    public static String lockWaitTimeoutStatement(Duration timeout) {
        return "SET innodb_lock_wait_timeout=" + timeout.getSeconds();
    }

    public static ZoneId parseZoneId(String zoneId) {
        AssertUtils.requireNonEmpty(zoneId, "zoneId must not be empty");
        String realId = zoneId.startsWith(ZONE_PREFIX_POSIX) || zoneId.startsWith(ZONE_PREFIX_RIGHT) ? zoneId.substring(6) : zoneId;
        switch (realId) {
            case "Factory": {
                return ZoneOffset.UTC;
            }
            case "ROC": {
                return ZoneOffset.ofHours(8);
            }
        }
        return ZoneId.of(realId, ZoneId.SHORT_IDS).normalized();
    }

    private StringUtils() {
    }
}

