/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.internal.util.NettyBufferUtils;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import java.util.List;

public final class LargeFieldValue
extends AbstractReferenceCounted
implements FieldValue {
    private final List<ByteBuf> buffers;

    public LargeFieldValue(List<ByteBuf> buffers) {
        this.buffers = AssertUtils.requireNonNull(buffers, "buffers must not be null");
    }

    public List<ByteBuf> getBufferSlices() {
        int size = this.buffers.size();
        ByteBuf[] buffers = new ByteBuf[size];
        for (int i = 0; i < size; ++i) {
            buffers[i] = this.buffers.get(i).slice();
        }
        return InternalArrays.asImmutableList(buffers);
    }

    public ReferenceCounted touch(Object hint) {
        if (this.buffers.isEmpty()) {
            return this;
        }
        for (ByteBuf buf : this.buffers) {
            buf.touch(hint);
        }
        return this;
    }

    protected void deallocate() {
        if (this.buffers.isEmpty()) {
            return;
        }
        NettyBufferUtils.releaseAll(this.buffers);
    }
}

