/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.asyncer.r2dbc.mysql.message.client.HandshakeResponse;
import io.asyncer.r2dbc.mysql.message.client.ScalarClientMessage;
import io.asyncer.r2dbc.mysql.message.client.SslRequest41;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;

final class HandshakeResponse41
extends ScalarClientMessage
implements HandshakeResponse {
    private static final int ONE_BYTE_MAX_INT = 255;
    private final SslRequest41 header;
    private final String user;
    private final byte[] authentication;
    private final String authType;
    private final String database;
    private final Map<String, String> attributes;
    private final int zstdCompressionLevel;

    HandshakeResponse41(Capability capability, int collationId, String user, byte[] authentication, String authType, String database, Map<String, String> attributes, int zstdCompressionLevel) {
        this.header = new SslRequest41(capability, collationId);
        this.user = AssertUtils.requireNonNull(user, "user must not be null");
        this.authentication = AssertUtils.requireNonNull(authentication, "authentication must not be null");
        this.database = AssertUtils.requireNonNull(database, "database must not be null");
        this.authType = AssertUtils.requireNonNull(authType, "authType must not be null");
        this.attributes = AssertUtils.requireNonNull(attributes, "attributes must not be null");
        this.zstdCompressionLevel = zstdCompressionLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeResponse41)) {
            return false;
        }
        HandshakeResponse41 that = (HandshakeResponse41)o;
        return this.zstdCompressionLevel == that.zstdCompressionLevel && this.header.equals(that.header) && this.user.equals(that.user) && Arrays.equals(this.authentication, that.authentication) && this.authType.equals(that.authType) && this.database.equals(that.database) && this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = 31 * result + this.user.hashCode();
        result = 31 * result + Arrays.hashCode(this.authentication);
        result = 31 * result + this.authType.hashCode();
        result = 31 * result + this.database.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return 31 * result + this.zstdCompressionLevel;
    }

    public String toString() {
        return "HandshakeResponse41{capability=" + this.header.getCapability() + ", collationId=" + this.header.getCollationId() + ", user='" + this.user + "', authentication=REDACTED, authType='" + this.authType + "', database='" + this.database + "', attributes=" + this.attributes + ", zstdCompressionLevel=" + this.zstdCompressionLevel + '}';
    }

    @Override
    protected void writeTo(ByteBuf buf, ConnectionContext context) {
        this.header.writeTo(buf);
        Capability capability = this.header.getCapability();
        Charset charset = context.getClientCollation().getCharset();
        HandshakeResponse.writeCString(buf, this.user, charset);
        if (capability.isVarIntSizedAuthAllowed()) {
            HandshakeResponse41.writeVarIntSizedBytes(buf, this.authentication);
        } else if (this.authentication.length <= 255) {
            buf.writeByte(this.authentication.length).writeBytes(this.authentication);
        } else {
            buf.writeByte(0);
        }
        if (capability.isConnectWithDatabase()) {
            HandshakeResponse.writeCString(buf, this.database, charset);
        }
        if (capability.isPluginAuthAllowed()) {
            HandshakeResponse.writeCString(buf, this.authType, StandardCharsets.UTF_8);
        }
        if (capability.isConnectionAttributesAllowed()) {
            this.writeAttrs(buf, charset);
        }
        if (capability.isZstdCompression()) {
            buf.writeByte(this.zstdCompressionLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAttrs(ByteBuf buf, Charset charset) {
        if (this.attributes.isEmpty()) {
            buf.writeByte(0);
            return;
        }
        ByteBuf attributesBuf = buf.alloc().buffer();
        try {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                HandshakeResponse41.writeVarIntString(attributesBuf, entry.getKey(), charset);
                HandshakeResponse41.writeVarIntString(attributesBuf, entry.getValue(), charset);
            }
            HandshakeResponse41.writeVarIntSizedBytes(buf, attributesBuf);
        }
        finally {
            attributesBuf.release();
        }
    }

    private static void writeVarIntString(ByteBuf buf, String value, Charset charset) {
        if (value.isEmpty()) {
            buf.writeByte(0);
            return;
        }
        HandshakeResponse41.writeVarIntSizedBytes(buf, value.getBytes(charset));
    }

    private static void writeVarIntSizedBytes(ByteBuf buf, byte[] value) {
        int size = value.length;
        if (size == 0) {
            buf.writeByte(0);
            return;
        }
        VarIntUtils.writeVarInt(buf, size);
        buf.writeBytes(value);
    }

    private static void writeVarIntSizedBytes(ByteBuf buf, ByteBuf value) {
        int size = value.readableBytes();
        if (size == 0) {
            buf.writeByte(0);
            return;
        }
        VarIntUtils.writeVarInt(buf, size);
        buf.writeBytes(value);
    }
}

