/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.aop.support;

import io.basc.framework.aop.ConfigurableProxyFactory;
import io.basc.framework.aop.MethodInterceptor;
import io.basc.framework.aop.Proxy;
import io.basc.framework.aop.ProxyFactory;
import io.basc.framework.aop.WriteReplaceInterface;
import io.basc.framework.aop.support.DefaultProxyFactory;
import io.basc.framework.core.reflect.MethodInvoker;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.factory.support.SpiServiceLoader;
import io.basc.framework.util.ArrayUtils;
import java.io.Serializable;
import java.lang.reflect.Method;

public final class ProxyUtils {
    private static final ConfigurableProxyFactory FACTORY = new DefaultProxyFactory();

    private ProxyUtils() {
    }

    public static ProxyFactory getFactory() {
        return FACTORY;
    }

    public static <T> T proxyIngoreMethod(ProxyFactory proxyFactory, Class<? extends T> clazz, T instance, IgnoreMethodAccept ignoreMethodAccept) {
        IgnoreMethodFilter methodInterceptor = new IgnoreMethodFilter(instance, ignoreMethodAccept);
        Proxy proxy = proxyFactory.getProxy(clazz, new Class[]{IgnoreMethodTarget.class}, methodInterceptor);
        return proxy.create();
    }

    public static boolean isIgnoreMethod(Method method) {
        return ReflectionUtils.isHashCodeMethod(method) && ReflectionUtils.isToStringMethod(method) && ReflectionUtils.isEqualsMethod(method);
    }

    public static int invokeHashCode(MethodInvoker invoker) {
        return System.identityHashCode(invoker.getInstance());
    }

    public static String invokeToString(MethodInvoker invoker) {
        return invoker.getInstance().getClass().getName() + "@" + Integer.toHexString(ProxyUtils.invokeHashCode(invoker));
    }

    public static boolean invokeEquals(MethodInvoker invoker, Object[] args) {
        if (args == null || args[0] == null) {
            return false;
        }
        return args[0].equals(invoker.getInstance());
    }

    public static Object invokeIgnoreMethod(MethodInvoker invoker, Object[] args) {
        if (ReflectionUtils.isHashCodeMethod(invoker.getMethod())) {
            return ProxyUtils.invokeHashCode(invoker);
        }
        if (ReflectionUtils.isToStringMethod(invoker.getMethod())) {
            return ProxyUtils.invokeToString(invoker);
        }
        if (ReflectionUtils.isEqualsMethod(invoker.getMethod())) {
            return ProxyUtils.invokeEquals(invoker, args);
        }
        throw new UnsupportedOperationException(invoker.getMethod().toString());
    }

    public static boolean isWriteReplaceMethod(MethodInvoker invoker) {
        return ArrayUtils.isEmpty(invoker.getMethod().getParameterTypes()) && invoker.getInstance() instanceof Serializable && invoker.getMethod().getName().equals("writeReplace");
    }

    public static boolean isWriteReplaceMethod(MethodInvoker invoker, boolean writeReplaceInterface) {
        if (ProxyUtils.isWriteReplaceMethod(invoker)) {
            if (writeReplaceInterface) {
                return WriteReplaceInterface.class.isAssignableFrom(invoker.getSourceClass());
            }
            return !WriteReplaceInterface.class.isAssignableFrom(invoker.getSourceClass());
        }
        return false;
    }

    static {
        SpiServiceLoader<ProxyFactory> serviceLoader = new SpiServiceLoader<ProxyFactory>(ProxyFactory.class);
        for (ProxyFactory proxyFactory : serviceLoader) {
            FACTORY.addProxyFactory(proxyFactory);
        }
    }

    public static interface IgnoreMethodAccept {
        public boolean accept(Method var1);
    }

    private static final class IgnoreMethodFilter
    implements MethodInterceptor {
        private final Object object;
        private final IgnoreMethodAccept ignoreMethodAccept;

        public IgnoreMethodFilter(Object object, IgnoreMethodAccept ignoreMethodAccept) {
            this.object = object;
            this.ignoreMethodAccept = ignoreMethodAccept;
        }

        @Override
        public Object intercept(MethodInvoker invoker, Object[] args) throws Throwable {
            if (ArrayUtils.isEmpty(args) && invoker.getMethod().getName().equals("getIgnoreMethodTarget")) {
                return this.object;
            }
            if (this.ignoreMethodAccept != null && this.ignoreMethodAccept.accept(invoker.getMethod())) {
                return null;
            }
            return invoker.invoke(args);
        }
    }

    public static interface IgnoreMethodTarget {
        public Object getIgnoreMethodTarget();
    }
}

