/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec;

import io.basc.framework.codec.Decoder;
import io.basc.framework.codec.Encoder;
import io.basc.framework.codec.IdentityCodec;
import io.basc.framework.codec.NestedCodec;
import io.basc.framework.codec.ReversalCodec;

public interface Codec<D, E>
extends Encoder<D, E>,
Decoder<E, D> {
    default public <F> Codec<F, E> from(Codec<F, D> codec) {
        return new NestedCodec(codec, this);
    }

    default public <T> Codec<D, T> to(Codec<E, T> codec) {
        return new NestedCodec(this, codec);
    }

    default public Codec<E, D> reversal() {
        return new ReversalCodec(this);
    }

    public static <R> Codec<R, R> identity() {
        return new IdentityCodec();
    }
}

