/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;

final class ReversalCodec<E, D>
implements Codec<E, D> {
    private final Codec<D, E> codec;

    ReversalCodec(Codec<D, E> codec) {
        this.codec = codec;
    }

    @Override
    public Codec<D, E> reversal() {
        return this.codec;
    }

    @Override
    public D encode(E source) throws EncodeException {
        try {
            return this.codec.decode(source);
        }
        catch (DecodeException e) {
            throw new EncodeException("reversal", e);
        }
    }

    @Override
    public E decode(D source) throws DecodeException {
        try {
            return this.codec.encode(source);
        }
        catch (EncodeException e) {
            throw new DecodeException("reversal", e);
        }
    }
}

