/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.encode;

import io.basc.framework.codec.CodecException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.encode.BytesEncoder;
import io.basc.framework.io.IOUtils;
import io.basc.framework.lang.NamedThreadLocal;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;

public class AsymmetricSigner
implements BytesEncoder,
Cloneable {
    private static Logger logger = LoggerFactory.getLogger(AsymmetricSigner.class);
    private final String algorithm;
    private final Object verifyKey;
    private final PrivateKey privateKey;
    private final NamedThreadLocal<Signature> encodeLocal;
    private final NamedThreadLocal<Signature> verifyLocal;
    private final SecureRandom secureRandom;

    public AsymmetricSigner(String algorithm, @Nullable PrivateKey privateKey, @Nullable PublicKey publicKey) {
        this(algorithm, privateKey, null, publicKey);
    }

    public AsymmetricSigner(String algorithm, @Nullable PrivateKey privateKey, @Nullable SecureRandom secureRandom, @Nullable PublicKey publicKey) {
        this.algorithm = algorithm;
        this.privateKey = privateKey;
        this.verifyKey = publicKey;
        this.secureRandom = secureRandom;
        this.encodeLocal = new NamedThreadLocal(algorithm);
        this.verifyLocal = new NamedThreadLocal(algorithm);
    }

    public AsymmetricSigner(String algorithm, @Nullable PrivateKey privateKey, @Nullable Certificate certificate) {
        this(algorithm, privateKey, null, certificate);
    }

    public AsymmetricSigner(String algorithm, @Nullable PrivateKey privateKey, @Nullable SecureRandom secureRandom, @Nullable Certificate certificate) {
        this.algorithm = algorithm;
        this.privateKey = privateKey;
        this.verifyKey = certificate;
        this.secureRandom = secureRandom;
        this.encodeLocal = new NamedThreadLocal(algorithm);
        this.verifyLocal = new NamedThreadLocal(algorithm);
    }

    protected AsymmetricSigner(AsymmetricSigner signer) {
        this.algorithm = signer.algorithm;
        this.privateKey = signer.privateKey;
        this.verifyKey = signer.verifyKey;
        this.secureRandom = signer.secureRandom;
        this.encodeLocal = signer.encodeLocal;
        this.verifyLocal = signer.verifyLocal;
    }

    public AsymmetricSigner clone() {
        return new AsymmetricSigner(this);
    }

    public Signature getEncodeSignature() throws CodecException {
        Signature signature = (Signature)this.encodeLocal.get();
        if (signature != null) {
            return signature;
        }
        try {
            signature = Signature.getInstance(this.algorithm);
            if (this.secureRandom == null) {
                signature.initSign(this.privateKey);
            } else {
                signature.initSign(this.privateKey, this.secureRandom);
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new CodecException(this.algorithm, e);
        }
        this.encodeLocal.set(signature);
        return signature;
    }

    public Signature getVerifySignature() throws CodecException {
        Signature signature;
        block5: {
            signature = (Signature)this.verifyLocal.get();
            if (signature != null) {
                return signature;
            }
            try {
                signature = Signature.getInstance(this.algorithm);
                if (this.verifyKey instanceof PublicKey) {
                    signature.initVerify((PublicKey)this.verifyKey);
                    break block5;
                }
                if (this.verifyKey instanceof Certificate) {
                    signature.initVerify((Certificate)this.verifyKey);
                    break block5;
                }
                throw new CodecException(this.verifyKey.toString());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new CodecException(this.algorithm, e);
            }
        }
        this.verifyLocal.set(signature);
        return signature;
    }

    @Override
    public boolean verify(InputStream source, int bufferSize, byte[] target) throws EncodeException, IOException {
        if (this.verifyKey == null) {
            return BytesEncoder.super.verify(source, bufferSize, target);
        }
        try {
            Signature signature = this.getVerifySignature();
            IOUtils.read(source, bufferSize, signature::update);
            return signature.verify(target);
        }
        catch (Exception e) {
            logger.error(e, "verify error");
            return false;
        }
    }

    @Override
    public void encode(InputStream source, int bufferSize, OutputStream target) throws IOException, EncodeException {
        Assert.requiredArgument(this.privateKey != null, "privateKey");
        try {
            Signature signature = this.getEncodeSignature();
            IOUtils.read(source, bufferSize, signature::update);
            byte[] sign = signature.sign();
            target.write(sign);
        }
        catch (Exception e) {
            throw new EncodeException(e);
        }
    }
}

