/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.encode;

import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.MultipleEncoder;
import io.basc.framework.codec.encode.FromBytesEncoder;
import io.basc.framework.codec.encode.ToBytesEncoder;
import io.basc.framework.io.BufferProcessor;
import io.basc.framework.io.FileUtils;
import io.basc.framework.io.IOUtils;
import io.basc.framework.io.UnsafeByteArrayInputStream;
import io.basc.framework.io.UnsafeByteArrayOutputStream;
import io.basc.framework.util.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public interface BytesEncoder
extends FromBytesEncoder<byte[]>,
ToBytesEncoder<byte[]>,
MultipleEncoder<byte[]> {
    @Override
    default public byte[] encode(byte[] source) throws EncodeException {
        return (byte[])FromBytesEncoder.super.encode(source);
    }

    default public void encode(byte[] source, File target, int count) throws IOException, EncodeException {
        UnsafeByteArrayInputStream input = new UnsafeByteArrayInputStream(source);
        this.encode((InputStream)input, source.length, target, count);
    }

    @Override
    default public void encode(byte[] source, OutputStream target) throws IOException, EncodeException {
        UnsafeByteArrayInputStream input = new UnsafeByteArrayInputStream(source);
        this.encode((InputStream)input, source.length, target);
    }

    default public void encode(byte[] source, OutputStream target, int count) throws IOException, EncodeException {
        UnsafeByteArrayInputStream input = new UnsafeByteArrayInputStream(source);
        this.encode((InputStream)input, source.length, target, count);
    }

    default public byte[] encode(InputStream source, int bufferSize, int count) throws IOException, EncodeException {
        Assert.isTrue(count > 0, "Count must be greater than 0");
        byte[] v = this.encode(source, bufferSize);
        if (count > 1) {
            return this.encode(v, count - 1);
        }
        return v;
    }

    @Override
    default public byte[] encode(InputStream source, int bufferSize) throws IOException, EncodeException {
        UnsafeByteArrayOutputStream target = new UnsafeByteArrayOutputStream(bufferSize);
        this.encode(source, bufferSize, (OutputStream)target);
        return target.toByteArray();
    }

    @Override
    default public void encode(InputStream source, OutputStream target) throws IOException, EncodeException {
        this.encode(source, 4096, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(InputStream source, int bufferSize, OutputStream target, int count) throws IOException, EncodeException {
        Assert.isTrue(count > 0, "Count must be greater than 0");
        if (count == 1) {
            this.encode(source, bufferSize, target);
            return;
        }
        File firstFile = File.createTempFile("encode", "count.0");
        this.encode(source, bufferSize, firstFile);
        File lastFile = firstFile;
        for (int i = 1; i < count - 1; ++i) {
            File targetFile = File.createTempFile("encode", "count." + i);
            try {
                this.encode(lastFile, bufferSize, targetFile);
            }
            finally {
                lastFile.delete();
            }
            lastFile = targetFile;
        }
        try {
            this.encode(lastFile, bufferSize, target);
        }
        finally {
            lastFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(File source, int bufferSize, OutputStream target) throws IOException, EncodeException {
        try (FileInputStream fis = new FileInputStream(source);){
            this.encode((InputStream)fis, bufferSize, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(File source, int bufferSize, OutputStream target, int count) throws IOException, EncodeException {
        try (FileInputStream fis = new FileInputStream(source);){
            this.encode((InputStream)fis, bufferSize, target, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(InputStream source, int bufferSize, File target) throws IOException, EncodeException {
        try (FileOutputStream fos = new FileOutputStream(target);){
            this.encode(source, bufferSize, (OutputStream)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(InputStream source, int bufferSize, File target, int count) throws IOException, EncodeException {
        try (FileOutputStream fos = new FileOutputStream(target);){
            this.encode(source, bufferSize, (OutputStream)fos, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(File source, int bufferSize, File target) throws IOException, EncodeException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);
            this.encode((InputStream)fis, bufferSize, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis, fos);
            throw throwable;
        }
        IOUtils.close(fis, fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(File source, int bufferSize, File target, int count) throws IOException, EncodeException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);
            this.encode((InputStream)fis, bufferSize, (OutputStream)fos, count);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis, fos);
            throw throwable;
        }
        IOUtils.close(fis, fos);
    }

    public void encode(InputStream var1, int var2, OutputStream var3) throws IOException, EncodeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Throwable> void encode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor, int count) throws IOException, EncodeException, E {
        Assert.isTrue(count > 0, "Count must be greater than 0");
        if (count == 1) {
            this.encode(source, bufferSize, targetProcessor);
            return;
        }
        File firstFile = File.createTempFile("encode", "count.0");
        this.encode(source, bufferSize, firstFile);
        File lastFile = firstFile;
        for (int i = 1; i < count - 1; ++i) {
            File targetFile = File.createTempFile("encode", "count." + i);
            try {
                this.encode(lastFile, bufferSize, targetFile);
            }
            finally {
                lastFile.delete();
            }
            lastFile = targetFile;
        }
        try {
            this.encode(lastFile, bufferSize, targetProcessor);
        }
        finally {
            lastFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Throwable> void encode(File source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws IOException, EncodeException, E {
        try (FileInputStream fis = new FileInputStream(source);){
            this.encode((InputStream)fis, bufferSize, targetProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Throwable> void encode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws IOException, EncodeException, E {
        File tempFile = File.createTempFile("encode", "processor");
        try {
            this.encode(source, bufferSize, tempFile);
            FileUtils.read(tempFile, bufferSize, targetProcessor);
        }
        finally {
            tempFile.delete();
        }
    }
}

