/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.encode;

import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.Encoder;
import io.basc.framework.codec.encode.NestedFromBytesEncoder;
import io.basc.framework.io.IOUtils;
import io.basc.framework.io.Resource;
import io.basc.framework.util.ObjectUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public interface FromBytesEncoder<E>
extends Encoder<byte[], E> {
    public E encode(InputStream var1, int var2) throws IOException, EncodeException;

    @Override
    default public boolean verify(InputStream source, E target) throws EncodeException, IOException {
        return this.verify(source, 4096, target);
    }

    default public boolean verify(InputStream source, int bufferSize, E target) throws EncodeException, IOException {
        return ObjectUtils.equals(this.encode(source, bufferSize), target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean verify(File source, int bufferSize, E target) throws EncodeException, IOException {
        boolean bl;
        if (!source.exists()) {
            return false;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            bl = ObjectUtils.equals(this.encode(fis, bufferSize), target);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis);
            throw throwable;
        }
        IOUtils.close((Closeable)fis);
        return bl;
    }

    @Override
    default public boolean verify(File source, E target) throws EncodeException, IOException {
        return this.verify(source, 4096, target);
    }

    @Override
    default public boolean verify(Resource source, E target) throws EncodeException, IOException {
        return this.verify(source, 4096, target);
    }

    default public boolean verify(Resource source, int bufferSize, E target) throws EncodeException, IOException {
        return source.read(is -> this.verify((InputStream)is, bufferSize, target));
    }

    @Override
    default public E encode(InputStream source) throws IOException, EncodeException {
        return this.encode(source, 4096);
    }

    default public <T> FromBytesEncoder<T> toEncoder(Encoder<E, T> encoder) {
        return new NestedFromBytesEncoder(this, encoder);
    }

    @Override
    default public E encode(byte[] source) throws EncodeException {
        if (source == null) {
            return null;
        }
        try {
            return this.encode(new ByteArrayInputStream(source), source.length);
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
    }

    @Override
    default public E encode(File source) throws IOException, EncodeException {
        return this.encode(source, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public E encode(File source, int bufferSize) throws IOException, EncodeException {
        E e;
        if (!source.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            e = this.encode(fis, bufferSize);
        }
        catch (Throwable throwable) {
            IOUtils.close(fis);
            throw throwable;
        }
        IOUtils.close((Closeable)fis);
        return e;
    }

    @Override
    default public E encode(Resource source) throws IOException, EncodeException {
        return (E)source.read(is -> this.encode((InputStream)is));
    }

    default public E encode(Resource source, int bufferSize) throws IOException, EncodeException {
        return (E)source.read(is -> this.encode((InputStream)is, bufferSize));
    }
}

