/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.encode;

import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.Encoder;
import io.basc.framework.codec.encode.MD5;
import io.basc.framework.codec.encode.SHA1;
import io.basc.framework.codec.support.Base64;
import io.basc.framework.codec.support.HexCodec;
import io.basc.framework.io.BufferProcessor;
import io.basc.framework.io.FileUtils;
import io.basc.framework.io.IOUtils;
import io.basc.framework.io.UnsafeByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public interface ToBytesEncoder<D>
extends Encoder<D, byte[]> {
    default public Encoder<D, String> toBase64() {
        return this.toEncoder(Base64.DEFAULT);
    }

    default public Encoder<D, String> toHex() {
        return this.toEncoder(HexCodec.DEFAULT);
    }

    default public Encoder<D, String> toMD5() {
        return this.toEncoder(MD5.DEFAULT);
    }

    default public Encoder<D, String> toSHA1() {
        return this.toEncoder(SHA1.DEFAULT);
    }

    @Override
    default public byte[] encode(D source) throws EncodeException {
        UnsafeByteArrayOutputStream target = new UnsafeByteArrayOutputStream();
        try {
            this.encode(source, target);
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
        return target.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void encode(D source, File target) throws IOException, EncodeException {
        FileOutputStream fos = new FileOutputStream(target);
        try {
            this.encode(source, fos);
        }
        finally {
            IOUtils.close((Closeable)fos);
        }
    }

    public void encode(D var1, OutputStream var2) throws IOException, EncodeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Throwable> void encode(D source, BufferProcessor<byte[], E> targetProcessor) throws IOException, EncodeException, E {
        File tempFile = File.createTempFile("encode", "processor");
        try {
            this.encode(source, tempFile);
            FileUtils.read(tempFile, targetProcessor);
        }
        finally {
            tempFile.delete();
        }
    }
}

