/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.support.CipherFactory;
import io.basc.framework.codec.support.CryptoCodec;
import io.basc.framework.io.BufferProcessor;
import io.basc.framework.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;

public class AsymmetricCodec
extends CryptoCodec {
    public static final String SHA1WithRSA = "SHA1WithRSA";
    private final int maxBlock;

    public AsymmetricCodec(String algorithm, @Nullable Key encodeKey, @Nullable Key decodeKey, int maxBlock) {
        super(algorithm, encodeKey, decodeKey, null, null);
        this.maxBlock = maxBlock;
    }

    public AsymmetricCodec(CipherFactory encoder, CipherFactory decoder, int maxBlock) {
        super(encoder, decoder);
        this.maxBlock = maxBlock;
    }

    protected AsymmetricCodec(AsymmetricCodec codec) {
        super(codec);
        this.maxBlock = codec.maxBlock;
    }

    @Override
    public AsymmetricCodec clone() {
        return new AsymmetricCodec(this);
    }

    @Override
    public <E extends Throwable> void encode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws IOException, EncodeException, E {
        super.encode(source, this.maxBlock - 11, targetProcessor);
    }

    @Override
    public <E extends Throwable> void decode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws DecodeException, IOException, E {
        super.decode(source, this.maxBlock, targetProcessor);
    }
}

