/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.Encoder;
import io.basc.framework.codec.encode.HmacMD5;
import io.basc.framework.codec.encode.HmacSHA1;
import io.basc.framework.codec.support.Gzip;
import io.basc.framework.codec.support.HexCodec;
import io.basc.framework.codec.support.ToBytesCodec;
import io.basc.framework.io.IOUtils;
import io.basc.framework.lang.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class CharsetCodec
implements ToBytesCodec<String> {
    public static final CharsetCodec DEFAULT = new CharsetCodec(Charset.defaultCharset());
    public static final CharsetCodec UTF_8 = new CharsetCodec(Constants.UTF_8);
    public static final CharsetCodec ISO_8859_1 = new CharsetCodec(Constants.ISO_8859_1);
    public static final CharsetCodec US_ASCII = new CharsetCodec(Constants.US_ASCII);
    private final Object charset;

    public CharsetCodec(String charsetName) {
        this.charset = charsetName;
    }

    public CharsetCodec(Charset charset) {
        this.charset = charset;
    }

    public String getCharsetName() {
        if (this.charset instanceof Charset) {
            return ((Charset)this.charset).name();
        }
        return (String)this.charset;
    }

    public Charset getCharset() {
        if (this.charset instanceof Charset) {
            return (Charset)this.charset;
        }
        return Charset.forName((String)this.charset);
    }

    @Override
    public byte[] encode(String source) throws EncodeException {
        if (source == null) {
            return null;
        }
        try {
            if (this.charset instanceof Charset) {
                return source.getBytes((Charset)this.charset);
            }
            return source.getBytes((String)this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodeException("charset=" + this.charset + ", source=" + source, e);
        }
    }

    @Override
    public void encode(String source, OutputStream target) throws IOException, EncodeException {
        byte[] v = this.encode(source);
        if (v == null) {
            return;
        }
        target.write(v);
    }

    @Override
    public String decode(InputStream source, int bufferSize) throws IOException, DecodeException {
        return this.decode(IOUtils.copyToByteArray(source, bufferSize));
    }

    @Override
    public String decode(byte[] source) throws DecodeException {
        if (source == null) {
            return null;
        }
        try {
            if (this.charset instanceof Charset) {
                return new String(source, (Charset)this.charset);
            }
            return new String(source, (String)this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncodeException("charset=" + this.charset + ", source=" + source, e);
        }
    }

    public Codec<String, String> gzip(Codec<byte[], String> codec) {
        return this.to(Gzip.DEFAULT).to(codec);
    }

    public Codec<String, String> gzip() {
        return this.gzip(HexCodec.DEFAULT);
    }

    public Encoder<String, String> toHmacMD5(String secretKey) {
        return this.toEncoder(new HmacMD5(this.encode(secretKey)).toEncoder((Encoder)HexCodec.DEFAULT));
    }

    public Encoder<String, String> toHmacSHA1(String secretKey) {
        return this.toEncoder(new HmacSHA1(this.encode(secretKey)).toEncoder((Encoder)HexCodec.DEFAULT));
    }

    public static CharsetCodec charset(Charset charset) {
        return new CharsetCodec(charset);
    }

    public static CharsetCodec charset(String charsetName) {
        return new CharsetCodec(charsetName);
    }
}

