/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.CodecException;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.io.BufferProcessor;
import io.basc.framework.io.IOUtils;
import io.basc.framework.lang.NamedThreadLocal;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CipherFactory
implements Cloneable {
    private final ThreadLocal<Cipher> threadLocal;
    private final int opmode;
    private final String transformation;
    private final Object key;
    private final Object params;
    private final SecureRandom secureRandom;
    private final Object provider;

    public CipherFactory(String transformation, int opmode, Object key, @Nullable Object params) {
        this(transformation, null, opmode, key, params, null);
    }

    public CipherFactory(String transformation, @Nullable Object provider, int opmode, Object key, @Nullable Object params) {
        this(transformation, provider, opmode, key, params, null);
    }

    public CipherFactory(String transformation, @Nullable Object provider, int opmode, Object key, @Nullable Object params, @Nullable SecureRandom secureRandom) {
        Assert.requiredArgument(StringUtils.hasText(transformation), "transformation");
        Assert.requiredArgument(key != null, "key");
        this.threadLocal = new NamedThreadLocal<Cipher>(transformation);
        this.transformation = transformation;
        this.provider = provider;
        this.opmode = opmode;
        this.key = key;
        this.params = params;
        this.secureRandom = secureRandom;
    }

    protected CipherFactory(CipherFactory cipherFactory) {
        this.threadLocal = cipherFactory.threadLocal;
        this.transformation = cipherFactory.transformation;
        this.provider = cipherFactory.provider;
        this.opmode = cipherFactory.opmode;
        this.key = cipherFactory.key;
        this.params = cipherFactory.params;
        this.secureRandom = cipherFactory.secureRandom;
    }

    public CipherFactory clone() {
        return new CipherFactory(this);
    }

    public int getOpmode() {
        return this.opmode;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getParams() {
        return this.params;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public Object getProvider() {
        return this.provider;
    }

    public Cipher getCipher() throws CodecException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = this.threadLocal.get();
        if (cipher != null) {
            return cipher;
        }
        if (this.provider == null) {
            cipher = Cipher.getInstance(this.transformation);
        } else if (this.provider instanceof String) {
            cipher = Cipher.getInstance(this.transformation, (String)this.provider);
        } else if (this.provider instanceof Provider) {
            cipher = Cipher.getInstance(this.transformation, (Provider)this.provider);
        } else {
            throw new CodecException(this.provider.toString());
        }
        try {
            ReflectionUtils.invokeOverloadMethod(cipher, "init", true, this.opmode, this.key, this.params, this.secureRandom);
        }
        catch (NoSuchMethodException e) {
            throw new CodecException(e);
        }
        this.threadLocal.set(cipher);
        return cipher;
    }

    public <E extends Throwable> long doFinal(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws IOException, CodecException, E {
        Cipher cipher;
        try {
            cipher = this.getCipher();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new CodecException(e);
        }
        return IOUtils.read(source, bufferSize, (buff, offset, len) -> {
            byte[] target;
            try {
                target = cipher.doFinal((byte[])buff, offset, len);
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new CodecException(e);
            }
            targetProcessor.process(target, 0, target.length);
        });
    }

    public byte[] doFinal(byte[] source) throws CodecException {
        Cipher cipher;
        try {
            cipher = this.getCipher();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new CodecException(e);
        }
        try {
            return cipher.doFinal(source);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CodecException(e);
        }
    }

    public byte[] doFinal(byte[] source, int offset, int len) throws CodecException {
        Cipher cipher;
        try {
            cipher = this.getCipher();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new CodecException(e);
        }
        try {
            return cipher.doFinal(source, offset, len);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CodecException(e);
        }
    }
}

