/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.CodecException;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.support.CipherFactory;
import io.basc.framework.codec.support.SecurityCodec;
import io.basc.framework.io.BufferProcessor;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class CryptoCodec
extends SecurityCodec
implements Cloneable {
    private final CipherFactory encoder;
    private final CipherFactory decoder;

    public CryptoCodec(String transformation, Object key, @Nullable Object params, @Nullable SecureRandom secureRandom) {
        this(transformation, key, key, params, secureRandom);
    }

    public CryptoCodec(String transformation, @Nullable Object encoderKey, @Nullable Object decoderKey, @Nullable Object params, @Nullable SecureRandom secureRandom) {
        this(encoderKey == null ? null : new CipherFactory(transformation, 1, encoderKey, params), decoderKey == null ? null : new CipherFactory(transformation, 2, decoderKey, params));
    }

    public CryptoCodec(@Nullable CipherFactory encoder, @Nullable CipherFactory decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    protected CryptoCodec(CryptoCodec codec) {
        this.decoder = codec.decoder;
        this.encoder = codec.encoder;
    }

    public CryptoCodec clone() {
        return new CryptoCodec(this);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        try {
            return SecretKeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CodecException(algorithm, e);
        }
    }

    public static SecretKey getSecretKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = CryptoCodec.getSecretKeyFactory(algorithm);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new CodecException(e);
        }
    }

    public static SecretKey getSecretKey(String algorithm, byte[] secretKey) {
        return new SecretKeySpec(secretKey, algorithm);
    }

    @Nullable
    public final CipherFactory getEncoder() {
        return this.encoder;
    }

    @Nullable
    public final CipherFactory getDecoder() {
        return this.decoder;
    }

    @Override
    public byte[] encode(byte[] source) throws EncodeException {
        Assert.requiredArgument(this.encoder != null, "encoder");
        return this.encoder.doFinal(source);
    }

    @Override
    public byte[] decode(byte[] source) throws DecodeException {
        Assert.requiredArgument(this.decoder != null, "decoder");
        return this.decoder.doFinal(source);
    }

    @Override
    public void encode(InputStream source, int bufferSize, OutputStream target) throws IOException, EncodeException {
        this.encode(source, bufferSize, target::write);
    }

    @Override
    public void decode(InputStream source, int bufferSize, OutputStream target) throws DecodeException, IOException {
        this.decode(source, bufferSize, target::write);
    }

    @Override
    public <E extends Throwable> void encode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws IOException, EncodeException, E {
        Assert.requiredArgument(this.encoder != null, "encoder");
        this.encoder.doFinal(source, bufferSize, targetProcessor);
    }

    @Override
    public <E extends Throwable> void decode(InputStream source, int bufferSize, BufferProcessor<byte[], E> targetProcessor) throws DecodeException, IOException, E {
        Assert.requiredArgument(this.decoder != null, "decoder");
        this.decoder.doFinal(source, bufferSize, targetProcessor);
    }
}

