/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;
import io.basc.framework.codec.support.BytesCodec;
import io.basc.framework.io.IOUtils;
import io.basc.framework.util.Assert;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Gzip
implements BytesCodec {
    public static final Gzip DEFAULT = new Gzip();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encode(InputStream source, int bufferSize, OutputStream target) throws IOException, EncodeException {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(target != null, "target");
        if (target instanceof GZIPOutputStream) {
            IOUtils.write(source, target, bufferSize);
            return;
        }
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(target);
            IOUtils.write(source, (OutputStream)gzip, bufferSize);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gzip);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)gzip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decode(InputStream source, int bufferSize, OutputStream target) throws DecodeException, IOException {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(target != null, "target");
        if (source instanceof GZIPInputStream) {
            IOUtils.write(source, target, bufferSize);
            return;
        }
        GZIPInputStream gzip = null;
        try {
            gzip = new GZIPInputStream(source);
            IOUtils.write(gzip, target, bufferSize);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gzip);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)gzip);
    }
}

