/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.codec.support;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.EncodeException;

public class HexCodec
implements Codec<byte[], String> {
    public static final HexCodec DEFAULT = new HexCodec();

    @Override
    public String encode(byte[] source) throws EncodeException {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < source.length; ++i) {
            String hex = Integer.toHexString(source[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex);
        }
        return sign.toString();
    }

    @Override
    public byte[] decode(String source) throws DecodeException {
        if (source.length() < 1) {
            return null;
        }
        byte[] result = new byte[source.length() / 2];
        for (int i = 0; i < source.length() / 2; ++i) {
            int high = Integer.parseInt(source.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(source.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

